/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.container.ReprocessorAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerModifiableForwarder;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ReprocessorAccessPortEntity
extends AbstractReprocessorEntity
implements INamedContainerProvider {
    @CapabilityInject(value=IItemHandler.class)
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    private final IoDirection _direction;
    private final ItemHandlerModifiableForwarder _forwarder;
    private final LazyOptional<IItemHandlerModifiable> _capability;

    public ReprocessorAccessPortEntity(TileEntityType<?> type, IoDirection direction) {
        super(type);
        this._direction = direction;
        this._forwarder = new ItemHandlerModifiableForwarder(ItemHelper.EMPTY_ITEM_HANDLER);
        this._capability = LazyOptional.of(() -> this._forwarder);
    }

    public IItemHandler getHandler() {
        return this._forwarder;
    }

    public IoDirection getDirection() {
        return this._direction;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ReprocessorAccessPortContainer(windowId, inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    @Override
    public void onPostMachineAssembled(MultiblockReprocessor controller) {
        super.onPostMachineAssembled(controller);
        this._forwarder.setHandler(this.getItemInventory(this._direction));
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this._forwarder.setHandler(ItemHelper.EMPTY_ITEM_HANDLER);
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        return this._direction.isInput() && PartPosition.TopFace == position || this._direction.isOutput() && position.isFace() || super.isGoodForPosition(position, validatorCallback);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ITEM_HANDLER_CAPABILITY == cap ? this._capability.cast() : super.getCapability(cap, side);
    }
}

