/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.CachedTranslations;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.util.NonNullConsumer;

public class RotorDescriptor
implements NonNullConsumer<MatrixStack> {
    final Direction RotorDirection;
    final int Length;
    final ShaftSection[] Sections;
    final Matrix4f Translation;
    final Supplier<IBakedModel> ShaftModel;
    final Supplier<IBakedModel> BladeModel;
    final BiConsumer<MatrixStack, Float> InitMatrix;
    private final Vector3f _initRotorDirectionVector;
    private final Matrix4f _initTranslate1;
    private final Matrix4f _initTranslate2;

    public static Builder builder(TurbineVariant variant, Direction rotorDirection, int length) {
        return new Builder(variant, rotorDirection, length);
    }

    public void accept(MatrixStack stack) {
        stack.func_227866_c_().func_227870_a_().func_226595_a_(this.Translation);
    }

    private RotorDescriptor(TurbineVariant variant, Direction rotorDirection, int length, List<ShaftSection> sections) {
        this.RotorDirection = rotorDirection;
        this.Length = length;
        this.Sections = sections.toArray(new ShaftSection[0]);
        this.Translation = CachedTranslations.getFor(rotorDirection);
        switch (variant) {
            case Basic: {
                this.ShaftModel = TurbineRotorModelBuilder.BASIC_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.BASIC_BLADE;
                break;
            }
            case Reinforced: {
                this.ShaftModel = TurbineRotorModelBuilder.REINFORCED_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.REINFORCED_BLADE;
                break;
            }
            default: {
                this.BladeModel = ModRenderHelper::getMissingModel;
                this.ShaftModel = this.BladeModel;
            }
        }
        this._initRotorDirectionVector = this.RotorDirection.func_229386_k_();
        float rotationOffsetX = 0.0f == this._initRotorDirectionVector.func_195899_a() ? 0.5f : 0.0f;
        float rotationOffsetY = 0.0f == this._initRotorDirectionVector.func_195900_b() ? 0.5f : 0.0f;
        float rotationOffsetZ = 0.0f == this._initRotorDirectionVector.func_195902_c() ? 0.5f : 0.0f;
        this._initTranslate1 = Matrix4f.func_226599_b_((float)rotationOffsetX, (float)rotationOffsetY, (float)rotationOffsetZ);
        this._initTranslate2 = Matrix4f.func_226599_b_((float)(-rotationOffsetX), (float)(-rotationOffsetY), (float)(-rotationOffsetZ));
        this.InitMatrix = this::initMatrix;
    }

    private void initMatrix(MatrixStack stack, float rotorAngle) {
        MatrixStack.Entry entry = stack.func_227866_c_();
        Matrix4f matrix = entry.func_227870_a_();
        Matrix3f normal = entry.func_227872_b_();
        Quaternion rotation = this._initRotorDirectionVector.func_229187_a_(rotorAngle);
        matrix.func_226595_a_(this._initTranslate1);
        matrix.func_226596_a_(rotation);
        normal.func_226115_a_(rotation);
        matrix.func_226595_a_(this._initTranslate2);
    }

    public static class Builder {
        private final TurbineVariant _variant;
        private final Direction _rotorDirection;
        private final int _length;
        private final List<ShaftSection> _shaft;

        public RotorDescriptor build() {
            return new RotorDescriptor(this._variant, this._rotorDirection, this._length, this._shaft);
        }

        public Builder section(RotorShaftState state, NonNullConsumer<ShaftSection.Builder> consumer) {
            ShaftSection.Builder builder = ShaftSection.builder(state);
            consumer.accept((Object)builder);
            this._shaft.add(builder.build());
            return this;
        }

        private Builder(TurbineVariant variant, Direction rotorDirection, int length) {
            this._variant = variant;
            this._rotorDirection = rotorDirection;
            this._length = length;
            this._shaft = Lists.newArrayList();
        }
    }
}

