/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.MethodInfo;
import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class ClassInfo {
    protected MixinCompiler mixinCompiler;

    protected ClassInfo(MixinCompiler mixinCompiler) {
        this.mixinCompiler = mixinCompiler;
    }

    public abstract String getName();

    public abstract boolean isInterface();

    public abstract Optional<ClassInfo> getSuperClass();

    public abstract Stream<ClassInfo> getInterfaces();

    public abstract Stream<MethodInfo> getMethods();

    public Stream<MethodInfo> getParentMethods() {
        return Streams.concat((Stream[])new Stream[]{Streams.stream(this.getSuperClass()), this.getInterfaces()}).flatMap(ClassInfo::getAllMethods);
    }

    public Stream<MethodInfo> getAllMethods() {
        return Streams.concat((Stream[])new Stream[]{this.getMethods(), this.getParentMethods()});
    }

    public Optional<MethodInfo> findPublicImpl(String name, String desc) {
        return this.getAllMethods().filter(m -> m.getName().equals(name)).filter(m -> m.getDesc().equals(desc)).filter(m -> !m.isAbstract() && !m.isPrivate()).findFirst();
    }

    public Optional<MethodInfo> findPublicParentImpl(String name, String desc) {
        return this.getParentMethods().filter(m -> m.getName().equals(name)).filter(m -> m.getDesc().equals(desc)).filter(m -> !m.isAbstract() && !m.isPrivate()).findFirst();
    }

    public Optional<ClassInfo> concreteParent() {
        return this.getSuperClass();
    }

    public boolean inheritsFrom(String parentName) {
        return ((Stream)Streams.concat((Stream[])new Stream[]{Streams.stream(this.concreteParent()), this.getInterfaces()}).parallel()).anyMatch(e -> e.getName().equals(parentName) || e.inheritsFrom(parentName));
    }

    public String getModuleName() {
        return this.getName();
    }
}

