/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.ICapabilityProviderPart;
import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.capability.ChainedProvider;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

@MultiPartTrait(value=ICapabilityProviderPart.class)
public class TCapabilityTile
extends TileMultiPart {
    private static final Direction[] N_SIDES = (Direction[])Util.func_200696_a((Object)new Direction[7], arr -> {
        arr[0] = null;
        System.arraycopy(Direction.values(), 0, arr, 1, 6);
    });
    private ChainedProvider[] providers = new ChainedProvider[7];

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        ChainedProvider p = this.providers[TCapabilityTile.ordinal(side)];
        if (p != null) {
            return p.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void copyFrom(TileMultiPart that) {
        super.copyFrom(that);
        if (that instanceof TCapabilityTile) {
            TCapabilityTile thatCapTile = (TCapabilityTile)that;
            this.providers = thatCapTile.providers;
        }
    }

    @Override
    public void bindPart(TMultiPart _part) {
        super.bindPart(_part);
        if (!(_part instanceof ICapabilityProvider)) {
            return;
        }
        if (!(_part instanceof ICapabilityProviderPart)) {
            throw new IllegalArgumentException("Part " + _part.getType().getRegistryName() + " must implement ICapabilityProviderPart to provide capabilities.");
        }
        ICapabilityProviderPart part = (ICapabilityProviderPart)((Object)_part);
        for (Direction side : N_SIDES) {
            if (!part.hasCapabilities(side)) continue;
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) {
                this.providers[s] = new ChainedProvider(part);
                continue;
            }
            if (side != null && this.getSlottedPart(s) == part) {
                this.providers[s].invalidateAll();
                this.providers[s] = new ChainedProvider(part, this.providers[s]);
                continue;
            }
            this.providers[s].append(part);
        }
    }

    @Override
    public void partRemoved(TMultiPart _part, int p) {
        super.partRemoved(_part, p);
        if (!(_part instanceof ICapabilityProviderPart)) {
            return;
        }
        ICapabilityProviderPart part = (ICapabilityProviderPart)((Object)_part);
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s] = this.providers[s].remove(part);
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.invalidateAll();
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            this.providers[s] = null;
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.invalidateAll();
    }

    @Override
    public void internalPartChange(TMultiPart part) {
        super.internalPartChange(part);
        if (!(part instanceof ICapabilityProviderPart)) {
            return;
        }
        this.invalidateFor((ICapabilityProviderPart)((Object)part));
    }

    @Override
    public void multiPartChange(Collection<TMultiPart> parts) {
        super.multiPartChange(parts);
        for (TMultiPart part : parts) {
            if (!(part instanceof ICapabilityProviderPart)) continue;
            this.invalidateFor((ICapabilityProviderPart)((Object)part));
        }
    }

    private void invalidateFor(ICapabilityProviderPart part) {
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s].invalidateFor(part);
        }
    }

    private void invalidateAll() {
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s].invalidateAll();
        }
    }

    private static int ordinal(Direction side) {
        return side == null ? 6 : side.ordinal();
    }
}

