/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier.filters;

import com.builtbroken.ai.improvements.modifier.filters.FilterNode;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import com.builtbroken.ai.improvements.modifier.filters.IFilterNode;
import com.builtbroken.ai.improvements.modifier.filters.NoopNode;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.entity.Entity;

public class FilterLayer
extends FilterNode {
    private FilterNode[] nodes = new FilterNode[5];
    private int size = 0;

    public FilterLayer(IFilterNode filter) {
        super(filter);
    }

    public void add(IFilterNode modifier) {
        if (modifier == null) {
            modifier = NoopNode.INSTANCE;
        }
        if (this.size == this.nodes.length) {
            this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 5);
        }
        this.nodes[this.size++] = new FilterNode(modifier);
    }

    @Override
    public FilterResult handle(Entity entity) {
        FilterResult filterResult;
        FilterResult filterResult2 = filterResult = this.action != null ? this.action.handle(entity) : FilterResult.FILTERED;
        if (filterResult != FilterResult.DID_NOTHING && this.nodes != null) {
            int i;
            for (i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] != null) continue;
                this.nodes[i] = NoopNode.INSTANCE;
            }
            for (i = 0; i < this.nodes.length; ++i) {
                FilterNode modifier = this.nodes[i];
                filterResult = modifier.handle(entity);
                if (filterResult != FilterResult.FILTERED) continue;
                ++modifier.callCount;
                if (modifier.callCount >= 0x3FFFFFFF) {
                    Arrays.sort(this.nodes, Comparator.comparingInt(m -> m.callCount));
                    int sum = Arrays.stream(this.nodes).mapToInt(m -> m.callCount).sum();
                    Arrays.stream(this.nodes).forEach(m -> {
                        m.callCount = (int)Math.floor((double)m.callCount / (double)sum);
                    });
                } else if (i != 0 && modifier.callCount > this.nodes[i - 1].callCount) {
                    FilterNode m2 = this.nodes[i];
                    this.nodes[i] = this.nodes[i - 1];
                    this.nodes[i - 1] = m2;
                }
                return filterResult;
            }
        }
        return filterResult;
    }
}

