/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.FluidRenderingManager;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.ModelDataMap;

public class ChiseledBlockModelDataExecutor {
    private static ExecutorService recalculationService;
    private static final Multimap<ChunkPos, BlockPos> positionsInProcessing;

    public static void updateModelDataCore(ChiseledBlockEntity tileEntity, Runnable onCompleteCallback) {
        ChiseledBlockModelDataExecutor.ensureThreadPoolSetup();
        positionsInProcessing.put((Object)new ChunkPos(tileEntity.func_174877_v()), (Object)tileEntity.func_174877_v());
        IBlockNeighborhood neighborhood = IBlockNeighborhoodBuilder.getInstance().build(direction -> tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v().func_177971_a(direction.func_176730_m())), direction -> {
            TileEntity otherTileEntity = tileEntity.func_145831_w().func_175625_s(tileEntity.func_174877_v().func_177971_a(direction.func_176730_m()));
            if (otherTileEntity instanceof IAreaAccessor) {
                return (IAreaAccessor)otherTileEntity;
            }
            return null;
        });
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            CombinedModel unknownRenderTypeModel;
            HashMap renderTypedModels = Maps.newHashMap();
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Extract model data from data");){
                RenderType currentType = MinecraftForgeClient.getRenderLayer();
                ForgeHooksClient.setRenderLayer(null);
                try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Unknown render layer model building");){
                    IBakedModel[] models = new ChiseledBlockBakedModel[ChiselRenderType.values().length];
                    try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Individual render types building");){
                        ChiselRenderType[] values = ChiselRenderType.values();
                        for (int i = 0; i < values.length; ++i) {
                            ChiselRenderType chiselRenderType = values[i];
                            try (IProfilerSection ignored4 = ProfilingManager.getInstance().withSection(chiselRenderType.name());){
                                ChiseledBlockBakedModel model = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), chiselRenderType, neighborhood::getBlockState, neighborhood::getAreaAccessor, tileEntity.func_174877_v());
                                models[i] = model;
                                continue;
                            }
                        }
                    }
                    ignored3 = ProfilingManager.getInstance().withSection("Combining model");
                    try {
                        unknownRenderTypeModel = new CombinedModel(models);
                    }
                    finally {
                        if (ignored3 != null) {
                            ignored3.close();
                        }
                    }
                }
                ignored2 = ProfilingManager.getInstance().withSection("Known render layer model building");
                try {
                    for (RenderType chunkBufferLayer : RenderType.func_228661_n_()) {
                        IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Known render layer model building for: " + chunkBufferLayer.toString());
                        try {
                            BaseBakedBlockModel baked;
                            IProfilerSection ignored4;
                            ForgeHooksClient.setRenderLayer((RenderType)chunkBufferLayer);
                            if (tileEntity.getStatistics().getStateCounts().isEmpty() || tileEntity.getStatistics().getStateCounts().size() == 1 && tileEntity.getStatistics().getStateCounts().containsKey(Blocks.field_150350_a.func_176223_P())) continue;
                            if (FluidRenderingManager.getInstance().isFluidRenderType(chunkBufferLayer)) {
                                ignored4 = ProfilingManager.getInstance().withSection("Solid and fluid model building");
                                try {
                                    ChiseledBlockBakedModel fluidModel;
                                    ChiseledBlockBakedModel solidModel;
                                    try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Solid");){
                                        solidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(chunkBufferLayer, false), neighborhood::getBlockState, neighborhood::getAreaAccessor, tileEntity.func_174877_v());
                                    }
                                    try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Fluid");){
                                        fluidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(chunkBufferLayer, true), neighborhood::getBlockState, neighborhood::getAreaAccessor, tileEntity.func_174877_v());
                                    }
                                    ignored5 = ProfilingManager.getInstance().withSection("Model combining");
                                    try {
                                        if (solidModel.isEmpty()) {
                                            baked = fluidModel;
                                        }
                                        if (fluidModel.isEmpty()) {
                                            baked = solidModel;
                                        }
                                        baked = new CombinedModel(solidModel, fluidModel);
                                    }
                                    finally {
                                        if (ignored5 != null) {
                                            ignored5.close();
                                        }
                                    }
                                }
                                finally {
                                    if (ignored4 != null) {
                                        ignored4.close();
                                    }
                                }
                            } else {
                                ignored4 = ProfilingManager.getInstance().withSection("Solid or fluid model building");
                                try {
                                    baked = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(chunkBufferLayer, false), neighborhood::getBlockState, neighborhood::getAreaAccessor, tileEntity.func_174877_v());
                                }
                                finally {
                                    if (ignored4 != null) {
                                        ignored4.close();
                                    }
                                }
                            }
                            renderTypedModels.put(chunkBufferLayer, baked);
                        }
                        finally {
                            if (ignored3 == null) continue;
                            ignored3.close();
                        }
                    }
                }
                finally {
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                }
                ForgeHooksClient.setRenderLayer((RenderType)currentType);
            }
            return new ModelDataMap.Builder().withInitial(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY, (Object)unknownRenderTypeModel).withInitial(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY, (Object)renderTypedModels).build();
        }, recalculationService).thenAcceptAsync(tileEntity::setModelData, (Executor)recalculationService)).thenRunAsync(onCompleteCallback, recalculationService)).thenRunAsync(() -> positionsInProcessing.remove((Object)new ChunkPos(tileEntity.func_174877_v()), (Object)tileEntity.func_174877_v()), recalculationService)).thenRunAsync(() -> {
            if (Minecraft.func_71410_x().field_71441_e == tileEntity.func_145831_w()) {
                ModelDataManager.requestModelDataRefresh((TileEntity)tileEntity);
                Minecraft.func_71410_x().field_71441_e.func_184138_a(tileEntity.func_174877_v(), tileEntity.func_195044_w(), tileEntity.func_195044_w(), 8);
            }
        }, (Executor)Minecraft.func_71410_x());
    }

    private static void ensureThreadPoolSetup() {
        if (recalculationService == null) {
            ClassLoader classLoader = ChiselsAndBits.class.getClassLoader();
            AtomicInteger genericThreadCounter = new AtomicInteger();
            recalculationService = Executors.newFixedThreadPool((Integer)IChiselsAndBitsAPI.getInstance().getConfiguration().getClient().modelBuildingThreadCount.get(), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setContextClassLoader(classLoader);
                thread.setName(String.format("Chisels and Bits Model builder #%s", genericThreadCounter.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    static {
        positionsInProcessing = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }
}

