/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.client.font.GuiBagFontRenderer;
import mod.chiselsandbits.client.icon.IconManager;
import mod.chiselsandbits.client.screens.widgets.GuiIconButton;
import mod.chiselsandbits.container.BagContainer;
import mod.chiselsandbits.inventory.wrapping.WrappingInventory;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.network.packets.BagGuiPacket;
import mod.chiselsandbits.network.packets.ClearBagGuiPacket;
import mod.chiselsandbits.network.packets.SortBagGuiPacket;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.jetbrains.annotations.NotNull;

public class BitBagScreen
extends ContainerScreen<BagContainer> {
    private static final ResourceLocation BAG_GUI_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/bitbag.png");
    private static GuiBagFontRenderer specialFontRenderer = null;
    private GuiIconButton trashBtn;
    private Slot hoveredBitSlot = null;
    boolean requireConfirm = true;
    boolean dontThrow = false;

    public BitBagScreen(BagContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 239;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.trashBtn = (GuiIconButton)this.func_230480_a_((Widget)new GuiIconButton(this.field_147003_i - 20, this.field_147009_r, IconManager.getInstance().getTrashIcon(), p_onPress_1_ -> {
            if (this.requireConfirm) {
                this.dontThrow = true;
                if (this.isValidBitItem()) {
                    this.requireConfirm = false;
                }
            } else {
                this.requireConfirm = true;
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new ClearBagGuiPacket(this.getInHandItem()));
            }
        }, (p_onTooltip_1_, p_onTooltip_2_, p_onTooltip_3_, p_onTooltip_4_) -> {
            if (this.isValidBitItem()) {
                IFormattableTextComponent msgNotConfirm = !this.getInHandItem().func_190926_b() ? LocalStrings.TrashItem.getText(this.getInHandItem().func_200301_q().getString()) : LocalStrings.Trash.getText();
                IFormattableTextComponent msgConfirm = !this.getInHandItem().func_190926_b() ? LocalStrings.ReallyTrashItem.getText(this.getInHandItem().func_200301_q().getString()) : LocalStrings.ReallyTrash.getText();
                List<IFormattableTextComponent> text = Collections.singletonList(this.requireConfirm ? msgNotConfirm : msgConfirm);
                GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            } else {
                List<IFormattableTextComponent> text = Collections.singletonList(LocalStrings.TrashInvalidItem.getText(this.getInHandItem().func_200301_q().getString()));
                GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }));
        this.func_230480_a_((Widget)new GuiIconButton(this.field_147003_i - 20, this.field_147009_r + 22, IconManager.getInstance().getSortIcon(), p_onPress_1_ -> ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new SortBagGuiPacket()), (p_onTooltip_1_, p_onTooltip_2_, p_onTooltip_3_, p_onTooltip_4_) -> {
            List<IFormattableTextComponent> text = Collections.singletonList(LocalStrings.Sort.getText());
            GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }));
    }

    BagContainer getBagContainer() {
        return (BagContainer)this.field_147002_h;
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean doThrow;
        boolean bl = doThrow = !this.dontThrow;
        if (this.requireConfirm && this.dontThrow) {
            this.dontThrow = false;
        }
        return doThrow && super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void func_230430_a_(@NotNull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_230450_a_(@NotNull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        int xOffset = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yOffset = (this.field_230709_l_ - this.field_147000_g) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BAG_GUI_TEXTURE);
        this.func_238474_b_(stack, xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
        if (specialFontRenderer == null) {
            specialFontRenderer = new GuiBagFontRenderer(this.field_230712_o_, (Integer)Configuration.getInstance().getServer().bagStackSize.get());
        }
        this.hoveredBitSlot = null;
        for (int slotIdx = 0; slotIdx < this.getBagContainer().customSlots.size(); ++slotIdx) {
            Slot slot = this.getBagContainer().customSlots.get(slotIdx);
            FontRenderer defaultFontRenderer = this.field_230712_o_;
            try {
                this.field_230712_o_ = specialFontRenderer;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
                this.func_238746_a_(stack, slot);
                RenderSystem.popMatrix();
            }
            finally {
                this.field_230712_o_ = defaultFontRenderer;
            }
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            int xDisplayPos = this.field_147003_i + slot.field_75223_e;
            int yDisplayPos = this.field_147009_r + slot.field_75221_f;
            this.hoveredBitSlot = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int INNER_SLOT_SIZE = 16;
            this.func_238468_a_(stack, xDisplayPos, yDisplayPos, xDisplayPos + 16, yDisplayPos + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
        if (!this.trashBtn.func_231047_b_(mouseX, mouseY)) {
            this.requireConfirm = true;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean duplicateButton = button == Minecraft.func_71410_x().field_71474_y.field_74322_I.getKey().func_197937_c() + 100;
        Slot slot = this.getSlotUnderMouse();
        if (slot == null) {
            slot = this.hoveredBitSlot;
        }
        if (slot != null && slot.field_75224_c instanceof WrappingInventory && Minecraft.func_71410_x().field_71439_g != null) {
            BagGuiPacket bagGuiPacket = new BagGuiPacket(slot.field_75222_d, button, duplicateButton, Minecraft.func_71410_x().func_228018_at_() != null && Screen.func_231173_s_());
            bagGuiPacket.doAction((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(bagGuiPacket);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private ItemStack getInHandItem() {
        return Minecraft.func_71410_x().field_71439_g == null ? ItemStack.field_190927_a : Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
    }

    private boolean isValidBitItem() {
        return this.getInHandItem().func_190926_b() || this.getInHandItem().func_77973_b() == ModItems.ITEM_BLOCK_BIT.get();
    }

    protected void func_230451_b_(@NotNull MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238407_a_(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)((BitBagItem)ModItems.BIT_BAG_DEFAULT.get()).func_200295_i(ItemStack.field_190927_a)), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 93), 0x404040);
    }
}

