/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.legacy;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.legacy.serialization.blob.BitStream;
import mod.chiselsandbits.legacy.serialization.blob.BlobSerializer;
import mod.chiselsandbits.legacy.serialization.blob.CrossWorldBlobSerializer;
import mod.chiselsandbits.legacy.serialization.blob.NbtBasedPalettedBlobSerializer;
import mod.chiselsandbits.legacy.serialization.blob.PalettedBlobSerializer;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegacyLoadManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LegacyLoadManager INSTANCE = new LegacyLoadManager();
    public static final int VERSION_COMPACT = 0;
    public static final int VERSION_CROSSWORLD = 2;
    public static final int VERSION_COMPACT_PALLETED_BROKEN = 3;
    public static final int VERSION_COMPACT_PALLETED = 4;
    private static final int ARRAY_SIZE = 4096;
    private static final String LEGACY_BYTE_VOXEL_ARRAY_KEY = "X";
    private static final ChunkSection EMPTY_SECTION = new ChunkSection(0);

    public static LegacyLoadManager getInstance() {
        return INSTANCE;
    }

    private LegacyLoadManager() {
    }

    public ChunkSection attemptLegacyBlockEntityLoad(CompoundNBT entityNbt) {
        if (!entityNbt.func_74764_b(LEGACY_BYTE_VOXEL_ARRAY_KEY)) {
            return EMPTY_SECTION;
        }
        byte[] legacyVoxelData = entityNbt.func_74770_j(LEGACY_BYTE_VOXEL_ARRAY_KEY);
        if (legacyVoxelData.length == 0) {
            return EMPTY_SECTION;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(legacyVoxelData);
        try {
            return this.attemptLegacyBlockEntityLoad(byteArrayInputStream);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read the legacy data from the byte array. Dropping TE Data.", (Throwable)e);
            return EMPTY_SECTION;
        }
    }

    private ChunkSection attemptLegacyBlockEntityLoad(ByteArrayInputStream byteArrayInputStream) throws IOException {
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x300000);
        int usedBytes = 0;
        int remainingBytes = 0;
        while ((remainingBytes = inflaterInputStream.read(byteBuffer.array(), usedBytes += remainingBytes, byteBuffer.limit() - usedBytes)) > 0) {
        }
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
        return this.attemptLegacyBlockEntityLoad(packetBuffer, byteBuffer);
    }

    private ChunkSection attemptLegacyBlockEntityLoad(PacketBuffer packetBuffer, ByteBuffer byteBuffer) {
        int packagedVersion = packetBuffer.readInt();
        BlobSerializer serializer = this.getBlobSerializerFromVersion(packagedVersion, packetBuffer);
        int byteOffset = packetBuffer.readInt();
        int bytesOfInterest = packetBuffer.readInt();
        BitStream bits = BitStream.valueOf(byteOffset, ByteBuffer.wrap(byteBuffer.array(), packetBuffer.readerIndex(), bytesOfInterest));
        ChunkSection resultingSection = new ChunkSection(0);
        for (int i = 0; i < 4096; ++i) {
            int stateId = serializer.readVoxelStateID(bits);
            BlockState state = IBlockStateIdManager.getInstance().getBlockStateFrom(stateId);
            BlockPos pos = LegacyLoadManager.getPositionFromDataIndex(i);
            resultingSection.func_177484_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state, false);
        }
        return resultingSection;
    }

    private BlobSerializer getBlobSerializerFromVersion(int version, PacketBuffer source) {
        if (version == 0) {
            return new BlobSerializer(source);
        }
        if (version == 3) {
            return new PalettedBlobSerializer(source);
        }
        if (version == 4) {
            return new NbtBasedPalettedBlobSerializer(source);
        }
        if (version == 2) {
            return new CrossWorldBlobSerializer(source);
        }
        throw new RuntimeException("Invalid Version: " + version);
    }

    private static BlockPos getPositionFromDataIndex(int dataIndex) {
        int x = dataIndex & 0xF;
        int y = dataIndex >> 4 & 0xF;
        int z = dataIndex >> 8 & 0xF;
        return new BlockPos(x, y, z);
    }
}

