/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.IMeasuringManager;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.measures.Measurement;
import mod.chiselsandbits.network.packets.MeasurementUpdatedPacket;
import mod.chiselsandbits.network.packets.MeasurementsUpdatedPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MeasuringManager
implements IMeasuringManager,
IPacketBufferSerializable {
    private static final MeasuringManager INSTANCE = new MeasuringManager();
    private final Table<ResourceLocation, UUID, Map<MeasuringMode, Measurement>> measurements = HashBasedTable.create();

    public static MeasuringManager getInstance() {
        return INSTANCE;
    }

    private MeasuringManager() {
    }

    @Override
    public Collection<? extends IMeasurement> getInWorld(ResourceLocation worldKey) {
        return this.measurements.row((Object)worldKey).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<? extends IMeasurement> getForPlayer(UUID playerId) {
        return this.measurements.column((Object)playerId).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Measurement create(World world, PlayerEntity playerEntity, Vector3d from, Vector3d to, MeasuringMode mode) {
        return new Measurement(playerEntity.func_110124_au(), from, to, mode, world.func_234923_W_().func_240901_a_());
    }

    @Override
    public void resetMeasurementsFor(UUID playerId) {
        this.measurements.columnMap().remove(playerId);
        this.syncToAll();
    }

    public void syncToAll() {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToEveryone(new MeasurementsUpdatedPacket());
    }

    @Override
    public void serializeInto(@NotNull PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(this.measurements.size());
        this.measurements.values().forEach(m -> {
            packetBuffer.func_150787_b(m.size());
            m.values().forEach(measurement -> measurement.serializeInto(packetBuffer));
        });
    }

    @Override
    public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
        this.measurements.clear();
        Collection measurements = IntStream.range(0, packetBuffer.func_150792_a()).mapToObj(index -> {
            int measurementCount = packetBuffer.func_150792_a();
            ArrayList measurementList = Lists.newArrayList();
            for (int i = 0; i < measurementCount; ++i) {
                Measurement measurement = new Measurement();
                measurement.deserializeFrom(packetBuffer);
                measurementList.add(measurement);
            }
            return measurementList;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        measurements.forEach(measurement -> {
            if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
                this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
            }
            ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        });
    }

    public void addOrUpdate(Measurement measurement) {
        if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
            this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
        }
        ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        this.syncToAll();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void createAndSend(Vector3d from, Vector3d to, MeasuringMode mode) {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        Measurement measurement = this.create((World)Minecraft.func_71410_x().field_71441_e, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, from, to, mode);
        MeasurementUpdatedPacket packet = new MeasurementUpdatedPacket(measurement);
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(packet);
    }
}

