/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.recipe;

import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.registrars.ModRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class BagDyeingRecipe
extends SpecialRecipe {
    public BagDyeingRecipe(ResourceLocation name) {
        super(name);
    }

    public boolean matches(@NotNull CraftingInventory inv, @NotNull World worldIn) {
        return !this.getOutput(inv).getBag().func_190926_b();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInventory inv) {
        Result output = this.getOutput(inv);
        if (!output.getBag().func_190926_b()) {
            return BitBagItem.dyeBag(output.bag, output.color);
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    private Result getOutput(CraftingInventory inv) {
        ItemStack bag = null;
        ItemStack dye = null;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is.func_190926_b()) continue;
            if (is.func_77973_b() == Items.field_151131_as || this.getDye(is) != null) {
                if (dye == null) {
                    dye = is;
                    continue;
                }
                return Result.EMPTY;
            }
            if (is.func_77973_b() instanceof BitBagItem) {
                if (bag == null) {
                    bag = is;
                    continue;
                }
                return Result.EMPTY;
            }
            return Result.EMPTY;
        }
        if (bag != null && dye != null) {
            return new Result(bag, this.getDye(dye));
        }
        return Result.EMPTY;
    }

    private DyeColor getDye(ItemStack is) {
        if (Tags.Items.DYES_WHITE.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.WHITE;
        }
        if (Tags.Items.DYES_ORANGE.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.ORANGE;
        }
        if (Tags.Items.DYES_MAGENTA.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.MAGENTA;
        }
        if (Tags.Items.DYES_LIGHT_BLUE.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.LIGHT_BLUE;
        }
        if (Tags.Items.DYES_YELLOW.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.YELLOW;
        }
        if (Tags.Items.DYES_LIME.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.LIME;
        }
        if (Tags.Items.DYES_PINK.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.PINK;
        }
        if (Tags.Items.DYES_GRAY.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.GRAY;
        }
        if (Tags.Items.DYES_LIGHT_GRAY.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.LIGHT_GRAY;
        }
        if (Tags.Items.DYES_CYAN.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.CYAN;
        }
        if (Tags.Items.DYES_PURPLE.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.PURPLE;
        }
        if (Tags.Items.DYES_BLUE.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.BLUE;
        }
        if (Tags.Items.DYES_BROWN.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.BROWN;
        }
        if (Tags.Items.DYES_GREEN.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.GREEN;
        }
        if (Tags.Items.DYES_RED.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.RED;
        }
        if (Tags.Items.DYES_BLACK.func_230235_a_((Object)is.func_77973_b())) {
            return DyeColor.BLACK;
        }
        if (is.func_77973_b() instanceof DyeItem) {
            DyeItem item = (DyeItem)is.func_77973_b();
            return item.func_195962_g();
        }
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.BAG_DYEING.get();
    }

    private static class Result {
        private static final Result EMPTY = new Result(ItemStack.field_190927_a, DyeColor.WHITE);
        private final ItemStack bag;
        private final DyeColor color;

        public Result(ItemStack bag, DyeColor dye) {
            this.bag = bag;
            this.color = dye;
        }

        public ItemStack getBag() {
            return this.bag;
        }

        public DyeColor getColor() {
            return this.color;
        }
    }
}

