/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.reloading;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.chiselsandbits.aabb.AABBManager;
import mod.chiselsandbits.api.reloading.ICacheClearingHandler;
import mod.chiselsandbits.change.ChangeTrackerManger;
import mod.chiselsandbits.chiseling.LocalChiselingContextCache;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Unit;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DataReloadingResourceManager
implements IFutureReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataReloadingResourceManager INSTANCE = new DataReloadingResourceManager();
    private final Set<ICacheClearingHandler> cacheClearingHandlers = Sets.newConcurrentHashSet();

    public static DataReloadingResourceManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void registerReloadListener(AddReloadListenerEvent addReloadListenerEvent) {
        LOGGER.info("Setting up data reloading resource manager.");
        addReloadListenerEvent.addListener((IFutureReloadListener)DataReloadingResourceManager.getInstance());
        DataReloadingResourceManager.getInstance().setup();
    }

    private DataReloadingResourceManager() {
    }

    public DataReloadingResourceManager registerCacheClearer(ICacheClearingHandler cacheClearingHandler) {
        this.cacheClearingHandlers.add(cacheClearingHandler);
        return this;
    }

    public void onResourceManagerReload() {
        LOGGER.info("Resetting common caches");
        this.cacheClearingHandlers.forEach(ICacheClearingHandler::clear);
    }

    private void setup() {
        this.cacheClearingHandlers.clear();
        this.registerCacheClearer(AABBManager.getInstance()::clearCache).registerCacheClearer(VoxelShapeManager.getInstance()::clearCache).registerCacheClearer(LocalChiselingContextCache.getInstance()::clearCache).registerCacheClearer(ChangeTrackerManger.getInstance()::clearCache);
    }

    @NotNull
    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, @NotNull IResourceManager manager, @NotNull IProfiler preparationProfiler, @NotNull IProfiler reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.func_219894_a();
            reloadProfiler.func_76320_a("C&B Data reload");
            this.onResourceManagerReload();
            reloadProfiler.func_76319_b();
            reloadProfiler.func_219897_b();
        }, gameExecutor);
    }
}

