/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.voxelshape;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import mod.chiselsandbits.voxelshape.VoxelShapeCalculator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelShapeManager
implements IVoxelShapeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final VoxelShapeManager INSTANCE = new VoxelShapeManager();
    private final SimpleMaxSizedCache<Key, VoxelShape> cache = new SimpleMaxSizedCache(() -> ((ForgeConfigSpec.LongValue)IChiselsAndBitsAPI.getInstance().getConfiguration().getCommon().collisionBoxCacheSize).get());

    private VoxelShapeManager() {
    }

    public static VoxelShapeManager getInstance() {
        return INSTANCE;
    }

    @Override
    public VoxelShape get(IAreaAccessor accessor, BlockPos offset, Function<IAreaAccessor, Predicate<IStateEntryInfo>> selectablePredicateBuilder, boolean simplify) {
        Key cacheKey = new Key(accessor.createNewShapeIdentifier(), offset, selectablePredicateBuilder.apply(accessor), simplify);
        return this.cache.get(cacheKey, () -> {
            VoxelShape calculatedShape = VoxelShapeCalculator.calculate(accessor, offset, selectablePredicateBuilder, simplify);
            if (calculatedShape.func_197766_b()) {
                return VoxelShapes.func_197880_a();
            }
            return calculatedShape;
        });
    }

    @Override
    public Optional<VoxelShape> getCached(IAreaShapeIdentifier identifier, BlockPos offset, Predicate<IStateEntryInfo> selectablePredicate, boolean simplify) {
        Key key = new Key(identifier, offset, selectablePredicate, simplify);
        return this.cache.getIfPresent(key);
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockPos offset;
        private final Predicate<IStateEntryInfo> predicate;
        private final boolean simplify;

        private Key(IAreaShapeIdentifier identifier, BlockPos offset, Predicate<IStateEntryInfo> predicate, boolean simplify) {
            this.identifier = identifier;
            this.offset = offset;
            this.predicate = predicate;
            this.simplify = simplify;
        }

        public String toString() {
            return "Key{identifier=" + this.identifier.toString() + ", offset=" + this.offset + ", predicate=" + this.predicate + ", simplify=" + this.simplify + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.simplify != key.simplify) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.offset, key.offset)) {
                return false;
            }
            return Objects.equals(this.predicate, key.predicate);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
            result = 31 * result + (this.simplify ? 1 : 0);
            return result;
        }
    }
}

