/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.proxy.ClientProxy;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageSlot;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridBalance;
import org.lwjgl.opengl.GL11;

public class ContainerScreenTerminalStorage<L, C extends ContainerTerminalStorageBase<L>>
extends ContainerScreenExtended<C> {
    private static int TAB_OFFSET_X = 24;
    private static int TAB_WIDTH = 24;
    private static int TAB_UNSELECTED_HEIGHT = 21;
    private static int TAB_SELECTED_HEIGHT = 24;
    private static int TAB_ICON_OFFSET = 4;
    private static int TAB_UNSELECTED_TEXTURE_X = 0;
    private static int TAB_SELECTED_TEXTURE_X = 24;
    private static int TAB_UNSELECTED_TEXTURE_Y = 225;
    private static int TAB_SELECTED_TEXTURE_Y = 225;
    private static int SCROLL_X = 198;
    private static int SCROLL_Y = 39;
    private static int SCROLL_HEIGHT = 88;
    private static int SEARCH_X = 104;
    private static int SEARCH_Y = 27;
    private static int SEARCH_WIDTH = 80;
    private static int SEARCH_HEIGHT = 20;
    private static int CHANNEL_X = 58;
    private static int CHANNEL_Y = 25;
    private static int CHANNEL_WIDTH = 42;
    private static int CHANNEL_HEIGHT = 15;
    private static int BUTTONS_OFFSET_X = 0;
    private static int BUTTONS_OFFSET_Y = 22;
    private static int BUTTONS_OFFSET = 4;
    private WidgetArrowedListField<String> fieldChannel;
    private WidgetScrollBar scrollBar;
    private WidgetTextFieldExtended fieldSearch;
    private ButtonImage buttonSetDefaults;
    private int firstRow;
    private boolean initialized;
    protected final Set<Slot> terminalDragSplittingSlots = Sets.newHashSet();
    protected boolean terminalDragSplitting;
    private int terminalDragMode;
    private int terminalDragSplittingButton;
    private int terminalDragSplittingRemnant;
    private boolean clicked;

    public ContainerScreenTerminalStorage(C container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.initialized = false;
        this.fieldChannel = new WidgetArrowedListField(Minecraft.func_71410_x().field_71466_p, this.field_147003_i + CHANNEL_X, this.field_147009_r + CHANNEL_Y, CHANNEL_WIDTH, CHANNEL_HEIGHT, true, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.channel"), true, ((ContainerTerminalStorageBase)((Object)this.getContainer())).getChannelStrings());
        this.fieldChannel.func_146203_f(15);
        this.fieldChannel.func_146189_e(true);
        this.fieldChannel.func_146193_g(0xFFFFFF);
        this.fieldChannel.func_146205_d(true);
        this.fieldChannel.func_146184_c(true);
        int activeChannel = ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel();
        if (activeChannel != -1) {
            this.fieldChannel.func_146180_a(Integer.toString(activeChannel));
        }
        this.scrollBar = new WidgetScrollBar(this.field_147003_i + SCROLL_X, this.field_147009_r + SCROLL_Y, SCROLL_HEIGHT, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.scrollbar"), firstRow -> {
            this.firstRow = firstRow;
        }, 0){

            public int getTotalRows() {
                Object container = ContainerScreenTerminalStorage.this.getContainer();
                Optional<ITerminalStorageTabClient<?>> tabOptional = ContainerScreenTerminalStorage.this.getSelectedClientTab();
                if (!tabOptional.isPresent()) {
                    return 0;
                }
                int totalSlots = tabOptional.get().getSlotCount(((ContainerTerminalStorageBase)((Object)container)).getSelectedChannel());
                return (int)Math.ceil((double)totalSlots / (double)ContainerScreenTerminalStorage.this.getSlotRowLength());
            }

            public int getVisibleRows() {
                return ContainerScreenTerminalStorage.this.getSlotVisibleRows();
            }
        };
        this.field_230705_e_.add(this.scrollBar);
        this.fieldSearch = new WidgetTextFieldExtended(Minecraft.func_71410_x().field_71466_p, this.field_147003_i + SEARCH_X, this.field_147009_r + SEARCH_Y, SEARCH_WIDTH, SEARCH_HEIGHT, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.search"));
        this.fieldSearch.func_146203_f(50);
        this.fieldSearch.func_146189_e(true);
        this.fieldSearch.func_146193_g(0xFFFFFF);
        this.fieldSearch.func_146205_d(true);
        this.fieldSearch.func_146184_c(true);
        this.fieldSearch.func_146185_a(false);
        this.buttonSetDefaults = (ButtonImage)this.func_230480_a_((Widget)new ButtonImage(this.field_147003_i + 202, this.field_147009_r + 193, 15, 15, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.setdefaults"), this.createServerPressable("button_set_defaults", b -> {}), true, (IImage)Images.ANVIL, -2, -3));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.initialized && this.getSelectedClientTab().isPresent()) {
            this.initialized = true;
            this.fieldSearch.func_146180_a(this.getSelectedClientTab().get().getInstanceFilter(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel()));
        }
        this.fieldSearch.func_146178_a();
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/part_terminal_storage.png");
    }

    public int getBaseXSize() {
        return 218;
    }

    public int getBaseYSize() {
        return 225;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, f, mouseX, mouseY);
        this.fieldChannel.func_230430_a_(matrixStack, mouseX, mouseY, f);
        this.fieldSearch.func_230430_a_(matrixStack, mouseX, mouseY, f);
        this.drawTabsBackground(matrixStack);
        this.drawTabContents(matrixStack, ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), DrawLayer.BACKGROUND, f, this.getGuiLeftTotal() + this.getSlotsOffsetX(), this.getGuiTopTotal() + this.getSlotsOffsetY(), mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, f, mouseX, mouseY);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227722_g_();
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                guiButton.func_230430_a_(matrixStack, mouseX, mouseY, f);
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.func_238483_d_();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Triple<Slot, Integer, Integer> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getContainer())))).getTabSlots(tabName)) {
                    tab.onCommonSlotRender((ContainerScreen)this, matrixStack, DrawLayer.BACKGROUND, 0.0f, this.field_147003_i + (Integer)slot.getMiddle(), this.field_147009_r + (Integer)slot.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).field_75222_d, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawTabsForeground(mouseX, mouseY);
        this.drawTabContents(matrixStack, ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), DrawLayer.FOREGROUND, 0.0f, this.getSlotsOffsetX(), this.getSlotsOffsetY(), mouseX, mouseY);
        RenderItemExtendedSlotCount.getInstance().field_77023_b = 150.0f;
        this.drawActiveStorageSlotItem(matrixStack, mouseX, mouseY);
        RenderItemExtendedSlotCount.getInstance().field_77023_b = 0.0f;
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                if (this.func_195359_a(button.getX(0, BUTTONS_OFFSET_X), button.getY(0, BUTTONS_OFFSET_Y + offset), guiButton.func_230998_h_(), guiButton.func_238483_d_(), mouseX, mouseY)) {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(new TranslationTextComponent(button.getTranslationKey()));
                    button.getTooltip((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL, lines);
                    this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.func_238483_d_();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Triple<Slot, Integer, Integer> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getContainer())))).getTabSlots(tabName)) {
                    tab.onCommonSlotRender((ContainerScreen)this, matrixStack, DrawLayer.FOREGROUND, 0.0f, this.field_147003_i + (Integer)slot.getMiddle(), this.field_147009_r + (Integer)slot.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).field_75222_d, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
        if (this.buttonSetDefaults.func_230449_g_()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(new TranslationTextComponent("gui.integratedterminals.terminal_storage.setdefaults"));
            lines.add(new TranslationTextComponent("gui.integratedterminals.terminal_storage.setdefaults.info").func_240699_a_(TextFormatting.GRAY));
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void drawCurrentScreen(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ResourceLocation oldTexture = this.texture;
        this.getSelectedClientTab().ifPresent(tab -> {
            ResourceLocation texture = tab.getBackgroundTexture();
            if (texture != null) {
                this.texture = texture;
            }
        });
        super.drawCurrentScreen(matrixStack, mouseX, mouseY, partialTicks);
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        for (int i1 = 0; i1 < ((ContainerTerminalStorageBase)((Object)this.getContainer())).field_75151_b.size(); ++i1) {
            Slot slot = (Slot)((ContainerTerminalStorageBase)((Object)this.getContainer())).field_75151_b.get(i1);
            if (!slot.func_111238_b()) continue;
            this.drawSlotOverlay(matrixStack, slot);
        }
        this.texture = oldTexture;
    }

    private void drawSlotOverlay(MatrixStack matrixStack, Slot slot) {
        this.getSelectedClientTab().ifPresent(tab -> {
            if (this.terminalDragSplitting && this.terminalDragSplittingSlots.contains(slot)) {
                if (tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), slot)) {
                    if (this.terminalDragSplittingSlots.size() == 1) {
                        return;
                    }
                    int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), tab.getActiveSlotQuantity());
                    if (dragQuantity > 0) {
                        String dragString = "+" + GuiHelpers.quantityToScaledString((long)dragQuantity);
                        RenderHelpers.drawScaledStringWithShadow((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)dragString, (int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (float)0.5f, (int)0xFFFF55);
                    }
                } else {
                    this.terminalDragSplittingSlots.remove(slot);
                    this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                }
            }
        });
    }

    public C getContainer() {
        return (C)((Object)((ContainerTerminalStorageBase)super.func_212873_a_()));
    }

    protected Optional<ITerminalStorageTabClient<?>> getTabByIndex(int tabIndex) {
        Collection<ITerminalStorageTabClient<?>> tabsClientList = ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClient().values();
        if (tabIndex >= 0 && tabIndex < tabsClientList.size()) {
            return Optional.of(Iterables.get(tabsClientList, (int)tabIndex));
        }
        return Optional.empty();
    }

    protected void setTabByIndex(int tabIndex) {
        this.getTabByIndex(tabIndex).ifPresent(tab -> {
            ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).setSelectedTab(tab.getName().toString());
            tab.resetActiveSlot();
            this.fieldSearch.func_146180_a(tab.getInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel()));
        });
        this.scrollBar.scrollTo(0.0f);
    }

    protected void playButtonClickSound() {
        this.getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        this.clicked = true;
        if (mouseButton == 0 && mouseY < (double)(this.getGuiTop() + TAB_UNSELECTED_HEIGHT) && mouseX > (double)(this.getGuiLeft() + TAB_OFFSET_X) && mouseX <= (double)(this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount() - 1))) {
            this.setTabByIndex((int)((mouseX - (double)TAB_OFFSET_X - (double)this.getGuiLeft()) / (double)TAB_WIDTH));
            this.playButtonClickSound();
            return true;
        }
        if (this.fieldChannel.func_231044_a_(mouseX, mouseY, mouseButton)) {
            int channel;
            try {
                channel = Integer.parseInt((String)this.fieldChannel.getActiveElement());
            }
            catch (NumberFormatException e) {
                channel = -1;
            }
            int finalChannel = channel;
            ((ContainerTerminalStorageBase)((Object)this.getContainer())).setSelectedChannel(channel);
            this.scrollBar.scrollTo(0.0f);
            tabOptional.ifPresent(tab -> this.fieldSearch.func_146180_a(tab.getInstanceFilter(finalChannel)));
            this.playButtonClickSound();
            return true;
        }
        if (tabOptional.isPresent()) {
            ITerminalStorageTabClient<?> tab2 = tabOptional.get();
            Slot playerSlot = this.getSlotUnderMouse();
            if (!(tab2.getActiveSlotId() < 0 || mouseButton != 0 && mouseButton != 1 && this.getMinecraft().field_71474_y.field_74322_I.getKey().func_197937_c() != mouseButton - 100 || playerSlot == null || this.terminalDragSplitting)) {
                this.terminalDragSplitting = true;
                this.terminalDragSplittingButton = mouseButton;
                this.terminalDragSplittingSlots.clear();
                if (mouseButton == 0) {
                    this.terminalDragMode = 0;
                } else if (mouseButton == 1) {
                    this.terminalDragMode = 1;
                } else if (this.getMinecraft().field_71474_y.field_74322_I.getKey().func_197937_c() == mouseButton - 100) {
                    this.terminalDragMode = 2;
                }
                return true;
            }
        } else if (this.getSlotUnderMouse() != null) {
            return false;
        }
        this.fieldSearch.func_231044_a_(mouseX, mouseY, mouseButton);
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getTabCommon(tab.getName().toString());
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                if (this.func_195359_a(button.getX(0, BUTTONS_OFFSET_X), button.getY(0, BUTTONS_OFFSET_Y + offset), guiButton.func_230998_h_(), guiButton.func_238483_d_(), mouseX, mouseY)) {
                    button.onClick(tab, tabCommon, guiButton, ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), mouseButton);
                    this.playButtonClickSound();
                    return;
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.func_238483_d_();
            }
        });
        if (!MinecraftHelpers.isShifted()) {
            return super.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot != null && slot.field_75223_e < 0) {
            return null;
        }
        return slot;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.getSelectedClientTab().map(tab -> {
            Slot slot;
            if (this.terminalDragSplitting & tab.getActiveSlotId() >= 0 && (slot = this.getSlotUnderMouse()) != null && (tab.getActiveSlotQuantity() > this.terminalDragSplittingSlots.size() || this.terminalDragMode == 2) && tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), slot)) {
                this.terminalDragSplittingSlots.add(slot);
                this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            return true;
        }
        return this.func_241217_q_() != null && this.func_231041_ay__() && mouseButton == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    private void updateTerminalDragSplitting(ITerminalStorageTabClient<?> tab) {
        if (this.terminalDragSplitting) {
            int quantityTotal = tab.getActiveSlotQuantity();
            this.terminalDragSplittingRemnant = tab.getActiveSlotQuantity();
            for (Slot slot : this.terminalDragSplittingSlots) {
                if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), slot)) continue;
                int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), quantityTotal);
                this.terminalDragSplittingRemnant -= tab.dragIntoSlot((Container)this.field_147002_h, ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), slot, dragQuantity, true);
            }
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.terminalDragSplitting && (this.terminalDragSplittingSlots.size() <= 1 || this.terminalDragSplittingButton != mouseButton)) {
            this.terminalDragSplitting = false;
            this.terminalDragSplittingSlots.clear();
            if (this.terminalDragSplittingButton != mouseButton) {
                return true;
            }
        }
        boolean dragged = false;
        if (this.terminalDragSplitting) {
            dragged = true;
            this.getSelectedClientTab().ifPresent(tab -> {
                if (tab.getActiveSlotQuantity() > 0) {
                    int quantityTotal;
                    int quantity = quantityTotal = tab.getActiveSlotQuantity();
                    for (Slot slot : this.terminalDragSplittingSlots) {
                        if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), slot)) continue;
                        int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), quantityTotal);
                        quantity -= tab.dragIntoSlot((Container)this.field_147002_h, ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), slot, dragQuantity, false);
                    }
                    tab.setActiveSlotQuantity(quantity);
                }
            });
        }
        this.terminalDragSplitting = false;
        this.terminalDragSplittingSlots.clear();
        this.terminalDragSplittingButton = -1;
        this.terminalDragMode = -1;
        this.terminalDragSplittingRemnant = 0;
        if (!dragged && this.clicked) {
            this.clicked = false;
            Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
            if (tabOptional.isPresent()) {
                int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
                Slot playerSlot = this.getSlotUnderMouse();
                boolean hasClickedOutside = this.func_195361_a(mouseX, mouseY, this.field_147003_i, this.field_147009_r, mouseButton);
                boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
                if (tabOptional.get().handleClick((Container)this.getContainer(), ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), slot, mouseButton, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.field_75222_d : -1)) {
                    return true;
                }
            }
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        if (tabOptional.isPresent()) {
            int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
            Slot playerSlot = this.getSlotUnderMouse();
            boolean hasClickedOutside = this.func_195361_a(mouseX, mouseY, this.field_147003_i, this.field_147009_r, 0);
            boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
            if (tabOptional.get().handleScroll((Container)this.getContainer(), ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), slot, delta, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.field_75222_d : -1)) {
                return true;
            }
        }
        return this.func_212930_a(mouseX, mouseY).filter(listener -> listener.func_231043_a_(mouseX, mouseY, delta)).isPresent();
    }

    protected boolean handleKeyCodeFirst(int keyCode, int scanCode) {
        InputMappings.Input inputCode = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(inputCode)) {
            this.fieldSearch.func_231049_c__(true);
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_NEXT.isActiveAndMatches(inputCode)) {
            if (((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount() > 0) {
                this.setTabByIndex((this.getSelectedClientTabIndex() + 1) % ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount());
                this.playButtonClickSound();
                return true;
            }
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_PREVIOUS.isActiveAndMatches(inputCode) && ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount() > 0) {
            this.setTabByIndex((((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount() + this.getSelectedClientTabIndex() - 1) % ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount());
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    protected boolean handleKeyCodeLast(int keyCode, int scanCode) {
        InputMappings.Input inputCode = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARPLAYER.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(false);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARSTORAGE.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(true);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_BALANCE.isActiveAndMatches(inputCode)) {
            this.balanceCraftingGrid();
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char keyCode, int scanCode) {
        if (this.handleKeyCodeFirst(keyCode, scanCode)) {
            return true;
        }
        if (this.fieldSearch.func_230999_j_()) {
            if (this.fieldSearch.func_231042_a_(keyCode, scanCode)) {
                this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), this.fieldSearch.func_146179_b()));
            }
            return true;
        }
        return this.handleKeyCodeLast(keyCode, scanCode) || super.func_231042_a_(keyCode, scanCode);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256) {
            if (this.handleKeyCodeFirst(keyCode, scanCode)) {
                return true;
            }
            if (this.fieldSearch.func_230999_j_()) {
                if (this.fieldSearch.func_231046_a_(keyCode, scanCode, modifiers)) {
                    this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), this.fieldSearch.func_146179_b()));
                }
                return true;
            }
            if (this.handleKeyCodeLast(keyCode, scanCode)) {
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    protected void clearCraftingGrid(boolean toStorage) {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            TerminalButtonItemStackCraftingGridClear.clearGrid((TerminalStorageTabIngredientComponentItemStackCraftingCommon)commonTab, ((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedChannel(), toStorage);
        }
    }

    protected void balanceCraftingGrid() {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridBalance(commonTab.getName().toString()));
        }
    }

    private boolean hasClickedInStorage(double mouseX, double mouseY) {
        return mouseX >= (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX()) && mouseX < (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX() + this.getSlotRowLength() * GuiHelpers.SLOT_SIZE - 1) && mouseY >= (double)(this.getGuiTopTotal() + this.getSlotsOffsetY()) && mouseY < (double)(this.getGuiTopTotal() + this.getSlotsOffsetY() + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE);
    }

    public int getStorageSlotIndexAtPosition(double mouseX, double mouseY) {
        if (this.hasClickedInStorage(mouseX, mouseY) && (mouseX - (double)this.getGuiLeftTotal() - (double)this.getSlotsOffsetX()) % (double)GuiHelpers.SLOT_SIZE < (double)GuiHelpers.SLOT_SIZE_INNER && (mouseY - (double)this.getGuiTopTotal() - (double)this.getSlotsOffsetY()) % (double)GuiHelpers.SLOT_SIZE < (double)GuiHelpers.SLOT_SIZE_INNER) {
            int rowLength = this.getSlotRowLength();
            int offset = this.getSelectedFirstRow() * rowLength;
            return offset + ((int)mouseX - this.getGuiLeftTotal() - this.getSlotsOffsetX()) / GuiHelpers.SLOT_SIZE + ((int)mouseY - this.getGuiTopTotal() - this.getSlotsOffsetY()) / GuiHelpers.SLOT_SIZE * this.getSlotRowLength();
        }
        return -1;
    }

    protected void drawTabsBackground(MatrixStack matrixStack) {
        int offsetX = TAB_OFFSET_X;
        ContainerScreenTerminalStorage.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.channel", (Object[])new Object[0]), (int)(this.getGuiLeft() + 30), (int)(this.getGuiTop() + 26), (int)0xFFFFFF);
        for (ITerminalStorageTabClient<?> tab : ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClient().values()) {
            boolean selected = tab.getName().toString().equals(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab());
            int x = this.getGuiLeft() + offsetX;
            int y = this.getGuiTop();
            int width = TAB_WIDTH;
            int height = selected ? TAB_SELECTED_HEIGHT : TAB_UNSELECTED_HEIGHT;
            int textureX = selected ? TAB_SELECTED_TEXTURE_X : TAB_UNSELECTED_TEXTURE_X;
            int textureY = selected ? TAB_SELECTED_TEXTURE_Y : TAB_UNSELECTED_TEXTURE_Y;
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.func_238474_b_(matrixStack, x, y, textureX, textureY, width, height);
            ItemStack icon = tab.getIcon();
            ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_227626_N_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            RenderHelper.func_227780_a_();
            GlStateManager.func_227623_K_();
            GL11.glEnable((int)2929);
            renderItem.func_180450_b(icon, x + TAB_ICON_OFFSET, y + TAB_ICON_OFFSET);
            RenderHelper.func_74518_a();
            GlStateManager.func_227627_O_();
            GL11.glDisable((int)2929);
            offsetX += width;
        }
    }

    protected int getSlotsOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetX).orElse(31);
    }

    protected int getSlotsOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetY).orElse(39);
    }

    protected int getSlotVisibleRows() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotVisibleRows).orElse(5);
    }

    protected int getSlotRowLength() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotRowLength).orElse(9);
    }

    protected int getSelectedFirstRow() {
        return this.firstRow;
    }

    protected void drawTabContents(MatrixStack matrixStack, String tabId, int channel, DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getClientTab(tabId);
        if (optionalTab.isPresent()) {
            ITerminalStorageTabClient<?> tab = optionalTab.get();
            if (layer == DrawLayer.BACKGROUND) {
                ContainerScreenTerminalStorage.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)tab.getStatus(channel), (int)(this.field_147003_i + 31 + GuiHelpers.SLOT_SIZE * 9 / 2), (int)(y + 2 + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE), (int)0xFFFFFF);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            int rowLength = this.getSlotRowLength();
            int limit = this.getSlotVisibleRows() * rowLength;
            int offset = this.getSelectedFirstRow() * rowLength;
            List<?> slots = tab.getSlots(channel, offset, limit);
            int slotX = x;
            int slotY = y;
            int slotI = 0;
            for (ITerminalStorageSlot slot : slots) {
                if (layer == DrawLayer.BACKGROUND) {
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    if (RenderHelpers.isPointInRegion((int)slotX, (int)slotY, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (double)mouseX, (double)mouseY)) {
                        ContainerScreenTerminalStorage.func_238467_a_((MatrixStack)matrixStack, (int)slotX, (int)slotY, (int)(slotX + GuiHelpers.SLOT_SIZE_INNER), (int)(slotY + GuiHelpers.SLOT_SIZE_INNER), (int)-2130706433);
                    }
                }
                slot.drawGuiContainerLayer((ContainerScreen)this, matrixStack, layer, partialTick, slotX, slotY, mouseX, mouseY, tab, channel, null);
                if (++slotI >= rowLength) {
                    slotX = x;
                    slotY += GuiHelpers.SLOT_SIZE;
                    slotI = 0;
                    continue;
                }
                slotX += GuiHelpers.SLOT_SIZE;
            }
        } else {
            GlStateManager.func_227702_d_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
            ContainerScreenTerminalStorage.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)(y - 1), (int)(x - 1 + GuiHelpers.SLOT_SIZE * this.getSlotRowLength()), (int)(y - 1 + GuiHelpers.SLOT_SIZE * this.getSlotVisibleRows()), (int)Helpers.RGBAToInt((int)50, (int)50, (int)50, (int)100));
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawActiveStorageSlotItem(MatrixStack matrixStack, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getSelectedClientTab();
        optionalTab.ifPresent(tab -> {
            int slotId = tab.getActiveSlotId();
            if (slotId >= 0) {
                int quantity = tab.getActiveSlotQuantity();
                List slots = tab.getSlots(((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), slotId, 1);
                if (!slots.isEmpty()) {
                    ITerminalStorageSlot slot = (ITerminalStorageSlot)slots.get(0);
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (this.terminalDragSplitting && this.terminalDragSplittingSlots.size() > 1) {
                        quantity = this.terminalDragSplittingRemnant;
                    }
                    String quantityString = GuiHelpers.quantityToScaledString((long)quantity);
                    if (quantity == 0) {
                        quantityString = TextFormatting.YELLOW + quantityString;
                    }
                    slot.drawGuiContainerLayer((ContainerScreen)this, matrixStack, DrawLayer.BACKGROUND, 0.0f, mouseX - this.field_147003_i - GuiHelpers.SLOT_SIZE_INNER / 4, mouseY - this.field_147009_r - GuiHelpers.SLOT_SIZE_INNER / 4, mouseX, mouseY, (ITerminalStorageTabClient)tab, ((ContainerTerminalStorageBase)((Object)((Object)this.getContainer()))).getSelectedChannel(), quantityString);
                }
            }
        });
    }

    protected Optional<ITerminalStorageTabClient<?>> getClientTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClient().get(tab));
    }

    protected Optional<ITerminalStorageTabCommon> getCommonTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsCommon().get(tab));
    }

    public Optional<ITerminalStorageTabClient<?>> getSelectedClientTab() {
        return this.getClientTab(((ContainerTerminalStorageBase)((Object)this.getContainer())).getSelectedTab());
    }

    protected int getSelectedClientTabIndex() {
        Optional<ITerminalStorageTabClient<?>> selectedTab = this.getSelectedClientTab();
        if (selectedTab.isPresent()) {
            int tabIndex = 0;
            for (ITerminalStorageTabClient<?> tabClient : ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClient().values()) {
                if (tabClient == selectedTab.get()) {
                    return tabIndex;
                }
                ++tabIndex;
            }
        }
        return -1;
    }

    protected void drawTabsForeground(int mouseX, int mouseY) {
        if (mouseY < this.getGuiTop() + TAB_UNSELECTED_HEIGHT && mouseX > this.getGuiLeft() + TAB_OFFSET_X && mouseX <= this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getContainer())).getTabsClientCount() - 1)) {
            int tabIndex = (mouseX - TAB_OFFSET_X - this.getGuiLeft()) / TAB_WIDTH;
            this.getTabByIndex(tabIndex).ifPresent(tab -> this.drawTooltip(tab.getTooltip(), mouseX - this.getGuiLeft(), mouseY - this.getGuiTop()));
        }
    }

    public WidgetTextFieldExtended getFieldSearch() {
        return this.fieldSearch;
    }

    public static enum DrawLayer {
        BACKGROUND,
        FOREGROUND;

    }
}

