/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.InventoryCraftingDirtyable;
import org.cyclops.integratedterminals.inventory.SlotCraftingAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetResult;

public class TerminalStorageTabIngredientComponentItemStackCraftingCommon
extends TerminalStorageTabIngredientComponentCommon<ItemStack, Integer> {
    private CraftingInventory inventoryCrafting;
    private CraftResultInventory inventoryCraftResult;
    private CraftingResultSlot slotCrafting;
    private List<Slot> slots;
    private TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.STORAGE;

    public TerminalStorageTabIngredientComponentItemStackCraftingCommon(ContainerTerminalStorageBase containerTerminalStorage, ResourceLocation name, IngredientComponent<ItemStack, Integer> ingredientComponent) {
        super(containerTerminalStorage, name, ingredientComponent);
    }

    public static int getCraftingResultSlotIndex(Container container, ResourceLocation name) {
        ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)container).getTabCommon(name.toString());
        TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
        return tabCommonCrafting.getSlotCrafting().field_75222_d;
    }

    @Override
    public List<Slot> loadSlots(Container container, int startIndex, PlayerEntity player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventoryOptional) {
        ITerminalStorageTabCommon.IVariableInventory variableInventory = variableInventoryOptional.get();
        this.slots = Lists.newArrayListWithCapacity((int)10);
        final IDirtyMarkListener dirtyListener = () -> this.updateCraftingResult(player, container, variableInventory);
        this.inventoryCraftResult = new CraftResultInventory(){

            public void func_70296_d() {
                dirtyListener.onDirty();
                super.func_70296_d();
            }
        };
        this.inventoryCrafting = new InventoryCraftingDirtyable(container, 3, 3, dirtyListener);
        this.slotCrafting = new SlotCraftingAutoRefill(player, this.inventoryCrafting, (IInventory)this.inventoryCraftResult, 0, 115, 76, this, (TerminalStorageTabIngredientComponentServer)((ContainerTerminalStorageBase)container).getTabServer(this.getName().toString()), (ContainerTerminalStorageBase)container);
        this.slots.add((Slot)this.slotCrafting);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slots.add(new Slot((IInventory)this.inventoryCrafting, j + i * 3, 31 + j * 18, 58 + i * 18));
            }
        }
        NonNullList<ItemStack> tabItems = variableInventory.getNamedInventory(this.getName().toString());
        if (tabItems != null) {
            int i = 0;
            for (ItemStack tabItem : tabItems) {
                if (i == 0) {
                    this.inventoryCraftResult.func_70299_a(i++, tabItem);
                    continue;
                }
                this.inventoryCrafting.func_70299_a(i++ - 1, tabItem);
            }
        }
        ArrayList returnSlots = Lists.newArrayList(this.slots);
        for (Triple<Slot, Integer, Integer> slot : ((ContainerTerminalStorageBase)container).getTabSlots(this.ingredientComponent.getName().toString())) {
            returnSlots.add(slot.getLeft());
        }
        return returnSlots;
    }

    public CraftingInventory getInventoryCrafting() {
        return this.inventoryCrafting;
    }

    public CraftResultInventory getInventoryCraftResult() {
        return this.inventoryCraftResult;
    }

    public CraftingResultSlot getSlotCrafting() {
        return this.slotCrafting;
    }

    public TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType getAutoRefill() {
        return this.autoRefill;
    }

    public void setAutoRefill(TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill) {
        this.autoRefill = autoRefill;
    }

    public void updateCraftingResult(PlayerEntity player, Container container, ITerminalStorageTabCommon.IVariableInventory variableInventory) {
        if (!player.field_70170_p.field_72995_K) {
            ServerPlayerEntity entityplayermp = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            ICraftingRecipe recipe = CraftingHelpers.findRecipeCached((IRecipeType)IRecipeType.field_222149_a, (IInventory)this.inventoryCrafting, (World)player.field_70170_p, (boolean)false).orElse(null);
            if (recipe != null && (recipe.func_192399_d() || !player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223618_u) || entityplayermp.func_192037_E().func_193830_f((IRecipe)recipe))) {
                this.inventoryCraftResult.func_193056_a((IRecipe)recipe);
                itemstack = recipe.func_77572_b((IInventory)this.inventoryCrafting);
            }
            this.inventoryCraftResult.func_70299_a(0, itemstack);
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetResult(this.getName().toString(), itemstack), (ServerPlayerEntity)player);
        }
        NonNullList latestItems = NonNullList.func_191196_a();
        for (Slot slot : this.slots) {
            latestItems.add((Object)slot.func_75211_c());
        }
        variableInventory.setNamedInventory(this.getName().toString(), (NonNullList<ItemStack>)latestItems);
    }
}

