/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class TerminalStorageState {
    public static final String SETTING_TAB = "tab";
    public static final String SETTING_SEARCH = "search";
    public static final String SETTING_BUTTON = "button";
    public static final String PLAYER_TAG_DEFAULT_KEY = "integratedterminals:terminalStorageStateDefault";
    private CompoundNBT tag;
    private IDirtyMarkListener dirtyMarkListener;

    public TerminalStorageState(IDirtyMarkListener dirtyMarkListener) {
        this(new CompoundNBT(), dirtyMarkListener);
    }

    public TerminalStorageState(CompoundNBT tag, IDirtyMarkListener dirtyMarkListener) {
        this.tag = tag;
        this.dirtyMarkListener = dirtyMarkListener;
    }

    public void setDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListener = dirtyMarkListener;
    }

    protected void markDirty() {
        this.dirtyMarkListener.onDirty();
    }

    public CompoundNBT getTag() {
        return this.tag;
    }

    public void setTag(CompoundNBT tag) {
        this.tag = tag;
        this.markDirty();
    }

    public String getTab() {
        return this.tag.func_74779_i(SETTING_TAB);
    }

    public boolean hasTab() {
        return this.tag.func_150297_b(SETTING_TAB, 8);
    }

    public void setTab(@Nullable String tab) {
        if (tab != null) {
            this.tag.func_74778_a(SETTING_TAB, tab);
        } else {
            this.tag.func_82580_o(SETTING_TAB);
        }
        this.markDirty();
    }

    public String getSearch(String tab, int channel) {
        return this.tag.func_74779_i("search_" + tab + "_" + channel);
    }

    public boolean hasSearch(String tab, int channel) {
        return this.tag.func_150297_b("search_" + tab + "_" + channel, 8);
    }

    public void setSearch(String tab, int channel, @Nullable String search) {
        if (tab != null) {
            this.tag.func_74778_a("search_" + tab + "_" + channel, search);
        } else {
            this.tag.func_82580_o("search_" + tab + "_" + channel);
        }
        this.markDirty();
    }

    public INBT getButton(String tab, String buttonName) {
        return this.tag.func_74781_a("button_" + tab + "_" + buttonName);
    }

    public boolean hasButton(String tab, String buttonName) {
        return this.tag.func_74764_b("button_" + tab + "_" + buttonName);
    }

    public void setButton(String tab, String buttonName, @Nullable INBT button) {
        if (button != null) {
            this.tag.func_218657_a("button_" + tab + "_" + buttonName, button);
        } else {
            this.tag.func_82580_o(SETTING_TAB);
        }
        this.markDirty();
    }

    public void writeToPacketBuffer(PacketBuffer packetBuffer) {
        packetBuffer.func_150786_a(this.tag);
    }

    public static TerminalStorageState readFromPacketBuffer(PacketBuffer packetBuffer) {
        return new TerminalStorageState(packetBuffer.func_150793_b(), () -> {});
    }

    public static void setPlayerDefault(PlayerEntity playerEntity, TerminalStorageState state) {
        playerEntity.getPersistentData().func_218657_a(PLAYER_TAG_DEFAULT_KEY, (INBT)state.getTag().func_74737_b());
    }

    public static TerminalStorageState getPlayerDefault(PlayerEntity playerEntity, IDirtyMarkListener dirtyMarkListener) {
        if (playerEntity.getPersistentData().func_74764_b(PLAYER_TAG_DEFAULT_KEY)) {
            return new TerminalStorageState(playerEntity.getPersistentData().func_74775_l(PLAYER_TAG_DEFAULT_KEY), dirtyMarkListener);
        }
        return new TerminalStorageState(dirtyMarkListener);
    }
}

