/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.registry;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.registry.AbstractSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TileEntitySubRegistryHelper
extends AbstractSubRegistryHelper<TileEntityType<?>> {
    public TileEntitySubRegistryHelper(RegistryHelper parent, DeferredRegister<TileEntityType<?>> deferredRegister) {
        super(parent, deferredRegister);
    }

    public TileEntitySubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)parent.getModId()));
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> tileEntity, Supplier<Block[]> validBlocks) {
        return this.deferredRegister.register(name, () -> new TileEntityType(tileEntity, (Set)Sets.newHashSet((Object[])((Object[])validBlocks.get())), null));
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> tileEntity, Class<? extends Block> blockClass) {
        return this.deferredRegister.register(name, () -> new TileEntityType(tileEntity, (Set)Sets.newHashSet((Object[])TileEntitySubRegistryHelper.collectBlocks(blockClass)), null));
    }

    public static Block[] collectBlocks(Class<?> blockClass) {
        return (Block[])ForgeRegistries.BLOCKS.getValues().stream().filter(blockClass::isInstance).toArray(Block[]::new);
    }
}

