/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class IntegerSliderEntry
extends TooltipListEntry<Integer> {
    protected Slider sliderWidget;
    protected Button resetButton;
    protected AtomicInteger value;
    protected final long orginial;
    private int minimum;
    private int maximum;
    private final Consumer<Integer> saveConsumer;
    private final Supplier<Integer> defaultValue;
    private Function<Integer, ITextComponent> textGetter = integer -> new StringTextComponent(String.format("Value: %d", integer));
    private final List<IGuiEventListener> widgets;

    @Deprecated
    @ApiStatus.Internal
    public IntegerSliderEntry(ITextComponent fieldName, int minimum, int maximum, int value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer) {
        this(fieldName, minimum, maximum, value, resetButtonKey, defaultValue, saveConsumer, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerSliderEntry(ITextComponent fieldName, int minimum, int maximum, int value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, minimum, maximum, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerSliderEntry(ITextComponent fieldName, int minimum, int maximum, int value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.orginial = value;
        this.defaultValue = defaultValue;
        this.value = new AtomicInteger(value);
        this.saveConsumer = saveConsumer;
        this.maximum = maximum;
        this.minimum = minimum;
        this.sliderWidget = new Slider(0, 0, 152, 20, ((double)this.value.get() - (double)minimum) / (double)Math.abs(maximum - minimum));
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.setValue((Integer)defaultValue.get()));
        this.sliderWidget.func_238482_a_(this.textGetter.apply(this.value.get()));
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.sliderWidget, this.resetButton});
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public Function<Integer, ITextComponent> getTextGetter() {
        return this.textGetter;
    }

    public IntegerSliderEntry setTextGetter(Function<Integer, ITextComponent> textGetter) {
        this.textGetter = textGetter;
        this.sliderWidget.func_238482_a_(textGetter.apply(this.value.get()));
        return this;
    }

    @Override
    public Integer getValue() {
        return this.value.get();
    }

    @Deprecated
    public void setValue(int value) {
        this.sliderWidget.setValue((double)(MathHelper.func_76125_a((int)value, (int)this.minimum, (int)this.maximum) - this.minimum) / (double)Math.abs(this.maximum - this.minimum));
        this.value.set(Math.min(Math.max(value, this.minimum), this.maximum));
        this.sliderWidget.func_230979_b_();
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || (long)this.getValue().intValue() != this.orginial;
    }

    @Override
    public Optional<Integer> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }

    public IntegerSliderEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerSliderEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().intValue() != this.value.get();
        this.resetButton.field_230691_m_ = y;
        this.sliderWidget.field_230693_o_ = this.isEditable();
        this.sliderWidget.field_230691_m_ = y;
        ITextComponent displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x;
            this.sliderWidget.field_230690_l_ = x + this.resetButton.func_230998_h_() + 1;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.sliderWidget.field_230690_l_ = x + entryWidth - 150;
        }
        this.sliderWidget.func_230991_b_(150 - this.resetButton.func_230998_h_() - 2);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.sliderWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private class Slider
    extends AbstractSlider {
        protected Slider(int int_1, int int_2, int int_3, int int_4, double double_1) {
            super(int_1, int_2, int_3, int_4, NarratorChatListener.field_216868_a, double_1);
        }

        public void func_230979_b_() {
            this.func_238482_a_((ITextComponent)IntegerSliderEntry.this.textGetter.apply(IntegerSliderEntry.this.value.get()));
        }

        protected void func_230972_a_() {
            IntegerSliderEntry.this.value.set((int)((double)IntegerSliderEntry.this.minimum + (double)Math.abs(IntegerSliderEntry.this.maximum - IntegerSliderEntry.this.minimum) * this.field_230683_b_));
        }

        public boolean func_231046_a_(int int_1, int int_2, int int_3) {
            if (!IntegerSliderEntry.this.isEditable()) {
                return false;
            }
            return super.func_231046_a_(int_1, int_2, int_3);
        }

        public boolean func_231045_a_(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!IntegerSliderEntry.this.isEditable()) {
                return false;
            }
            return super.func_231045_a_(double_1, double_2, int_1, double_3, double_4);
        }

        public double getProgress() {
            return this.field_230683_b_;
        }

        public void setProgress(double integer) {
            this.field_230683_b_ = integer;
        }

        public void setValue(double integer) {
            this.field_230683_b_ = integer;
        }
    }
}

