/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;

public class KitchenSinkTileEntityRenderer
extends TileEntityRenderer<KitchenSinkTileEntity> {
    public KitchenSinkTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(KitchenSinkTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int i1) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tileEntity.func_195044_w().func_177229_b((Property)FurnitureHorizontalBlock.DIRECTION);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)direction.func_176736_b() * -90.0f - 90.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        this.drawFluid(tileEntity, matrixStack, renderTypeBuffer, 0.125f, 0.625f, 0.125f, 0.625f, 0.3125f, 0.75f, light);
        matrixStack.func_227865_b_();
    }

    private void drawFluid(KitchenSinkTileEntity te, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float x, float y, float z, float width, float height, float depth, int light) {
        Fluid fluid = te.getTank().getFluid().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)te.func_145831_w(), (BlockPos)te.func_174877_v(), (FluidState)fluid.func_207188_f())[0];
        float minU = sprite.func_94209_e();
        float maxU = Math.min(minU + (sprite.func_94212_f() - minU) * depth, sprite.func_94212_f());
        float minV = sprite.func_94206_g();
        float maxV = Math.min(minV + (sprite.func_94210_h() - minV) * width, sprite.func_94210_h());
        int waterColor = fluid.getAttributes().getColor((IBlockDisplayReader)te.func_145831_w(), te.func_174877_v());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        height = (float)((double)height * ((double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity()));
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(RenderType.func_228645_f_());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

