/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.command.CommandHats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.advancement.Advancements;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketPing;
import me.ichun.mods.hats.common.packet.PacketRehatify;
import me.ichun.mods.hats.common.packet.PacketUpdateHats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class EventHandlerServer {
    @SubscribeEvent
    public void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof LivingEntity) {
            event.addCapability(HatsSavedData.HatPart.CAPABILITY_IDENTIFIER, (ICapabilityProvider)new HatsSavedData.HatPart.CapProvider(new HatsSavedData.HatPart()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof PlayerEntity)) {
            LivingEntity living = (LivingEntity)event.getEntity();
            if (HatHandler.hasBeenRandomlyAllocated(living)) {
                HatHandler.checkValidity(living);
            }
            if (!HatHandler.hasBeenRandomlyAllocated(living)) {
                if (HatHandler.canWearHat(living) && living.func_70681_au().nextDouble() < HatHandler.getHatChance(living)) {
                    HatHandler.assignHat(living);
                } else {
                    HatHandler.assignNoHat(living);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!(event.getEntityLiving().func_130014_f_().field_72995_K || event.getEntityLiving().field_70128_L || event.getEntityLiving() instanceof PlayerEntity)) {
            if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
                HatsSavedData.HatPart hatPart = HatHandler.getHatPart(event.getEntityLiving());
                if (hatPart.isAHat()) {
                    HatHandler.addHat((ServerPlayerEntity)event.getSource().func_76346_g(), hatPart);
                    HeadInfo info = HeadHandler.getHelper(event.getEntityLiving().getClass());
                    if (info != null && info.isBoss.booleanValue()) {
                        Advancements.CriteriaTriggers.KILL_BOSS_WITH_HAT.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                    }
                    if (!event.getEntityLiving().getClass().getName().contains("minecraft")) {
                        Advancements.CriteriaTriggers.NON_VANILLA_HAT.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                    }
                }
            } else if (event.getSource().func_76346_g() instanceof LivingEntity && event.getSource().func_76346_g().func_70089_S() && Hats.configServer.mobHatTakeover) {
                HatsSavedData.HatPart hatPart;
                LivingEntity killer = (LivingEntity)event.getSource().func_76346_g();
                HatsSavedData.HatPart killerHat = HatHandler.getHatPart(killer);
                if (HatHandler.canWearHat(killer) && !killerHat.isAHat() && (hatPart = HatHandler.getHatPart(event.getEntityLiving())).isAHat()) {
                    killerHat.read(hatPart.write(new CompoundNBT()));
                    HashMap<Integer, HatsSavedData.HatPart> entIdToHat = new HashMap<Integer, HatsSavedData.HatPart>();
                    entIdToHat.put(killer.func_145782_y(), hatPart);
                    Hats.channel.sendTo((AbstractPacket)new PacketRehatify(killer.func_145782_y()), PacketDistributor.TRACKING_ENTITY.with(() -> killer));
                    Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(entIdToHat), PacketDistributor.TRACKING_ENTITY.with(() -> killer));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Hats.channel.sendTo((AbstractPacket)new PacketPing(), (ServerPlayerEntity)event.getPlayer());
        Hats.channel.sendTo((AbstractPacket)new PacketUpdateHats(HatHandler.getPlayerHatsNBT(event.getPlayer()), true), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        HatHandler.getHatPart((LivingEntity)event.getPlayer()).read(HatHandler.getHatPart((LivingEntity)event.getOriginal()).write(new CompoundNBT()));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d() && ((ServerWorld)event.getWorld()).func_234923_W_().equals(World.field_234918_g_)) {
            HatHandler.setSaveData((HatsSavedData)((ServerWorld)event.getWorld()).func_217481_x().func_215752_a(HatsSavedData::new, "hats_save"));
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandHats.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
        HatHandler.setSaveData(null);
    }
}

