/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.client.model.ModelHat;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.EnumRarity;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.client.render.NativeImageTexture;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class HatInfo
implements Comparable<HatInfo> {
    @Nonnull
    public final String name;
    @Nonnull
    public final Project project;
    public final ArrayList<HatInfo> accessories = new ArrayList();
    public final ArrayList<String> hideParent = new ArrayList();
    public final ArrayList<Project.Part> allParts = new ArrayList();
    private EnumRarity rarity;
    private int worth = -1;
    public String forcedPool;
    public int forcedWorth = -1;
    public EnumRarity forcedRarity;
    public UUID contributorUUID;
    public String description;
    public String accessoryFor;
    public ArrayList<String> accessoryLayer = new ArrayList();
    public String accessoryParent;
    @OnlyIn(value=Dist.CLIENT)
    public ModelHat model;
    public float[] colouriser = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public float[] hsbiser = new float[]{1.0f, 1.0f, 1.0f};
    public boolean enchanted = false;
    @OnlyIn(value=Dist.CLIENT)
    public HashMap<String, NativeImageTexture> hsbToImage;
    public boolean hidden = false;

    public HatInfo(@Nonnull String name, @Nonnull Project project) {
        this.name = name;
        this.project = project;
        this.project.name = name;
        this.allParts.addAll(this.project.getAllParts());
        if (FMLEnvironment.dist.isClient()) {
            this.hsbToImage = new HashMap();
        }
        this.findMeta();
    }

    public String getDisplayName() {
        return (this.contributorUUID != null ? TextFormatting.AQUA : this.getRarity().getColour()).toString() + this.name;
    }

    public EnumRarity getRarity() {
        if (this.rarity == null) {
            if (this.forcedRarity != null) {
                this.rarity = this.forcedRarity;
            } else {
                HatHandler.RAND.setSeed((long)Math.abs((Hats.configServer.randSeed + this.getFullName()).hashCode()) * 154041013L);
                this.rarity = HatHandler.getRarityForChance(HatHandler.RAND.nextDouble());
            }
        }
        return this.rarity;
    }

    public void setRarity(EnumRarity rarity) {
        this.rarity = rarity;
    }

    public int getWorth() {
        if (this.worth < 0) {
            int value = Hats.configServer.tokensByRarity.get((Object)this.getRarity());
            if (this.accessoryFor != null) {
                value = (int)Math.ceil(Hats.configServer.accessoryCostMultiplier * (double)value);
            }
            this.worth = value;
        }
        return this.worth;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelHat getModel() {
        if (this.model == null) {
            this.model = new ModelHat(this);
        }
        return this.model;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void destroy() {
        this.project.destroy();
        for (NativeImageTexture value : this.hsbToImage.values()) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(value.getResourceLocation());
        }
        this.hsbToImage.clear();
        for (HatInfo accessory : this.accessories) {
            accessory.destroy();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, boolean cull) {
        if (!this.hidden) {
            for (Project.Part part : this.allParts) {
                part.showModel = true;
            }
            for (HatInfo accessory : this.accessories) {
                if (accessory.hidden || accessory.hideParent.isEmpty()) continue;
                for (String s : accessory.hideParent) {
                    for (Project.Part part : this.allParts) {
                        if (!part.name.equals(s)) continue;
                        part.showModel = false;
                    }
                }
            }
            ResourceLocation textureResourceLocation = this.getTextureResourceLocation();
            if (textureResourceLocation != null) {
                RenderType renderType = cull ? RenderType.func_228642_d_((ResourceLocation)textureResourceLocation) : RenderType.func_228644_e_((ResourceLocation)textureResourceLocation);
                this.getModel().func_225598_a_(stack, ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)renderType, (boolean)false, (boolean)this.enchanted), packedLightIn, packedOverlayIn, this.colouriser[0], this.colouriser[1], this.colouriser[2], this.colouriser[3]);
            }
            for (HatInfo accessory : this.accessories) {
                accessory.render(stack, bufferIn, packedLightIn, packedOverlayIn, cull);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureResourceLocation() {
        byte[] textureBytes = this.project.getTextureBytes();
        if (textureBytes != null) {
            String key = this.hsbiser[0] + "H" + this.hsbiser[1] + "S" + this.hsbiser[2] + "B";
            NativeImageTexture nit = this.hsbToImage.computeIfAbsent(key, k -> {
                Throwable throwable;
                NativeImage image;
                try {
                    image = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(textureBytes));
                    throwable = null;
                    try {
                        if (this.hsbiser[0] != 1.0f || this.hsbiser[1] != 1.0f || this.hsbiser[2] != 1.0f) {
                            for (int x = 0; x < image.func_195702_a(); ++x) {
                                for (int y = 0; y < image.func_195714_b(); ++y) {
                                    int clr = image.func_195709_a(x, y);
                                    if ((clr >> 24 & 0xFF) <= 0) continue;
                                    float[] hsb = Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, null);
                                    hsb[0] = hsb[0] + (1.0f - this.hsbiser[0]);
                                    for (int i = 1; i < this.hsbiser.length; ++i) {
                                        int n = i;
                                        hsb[n] = hsb[n] * this.hsbiser[i];
                                    }
                                    image.func_195700_a(x, y, (clr >> 24 & 0xFF) << 24 | Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]) & 0xFFFFFF);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    iChunUtil.LOGGER.error("Failed to read NativeImage for project: " + this.name);
                    e.printStackTrace();
                    return null;
                }
                NativeImageTexture nativeImage = new NativeImageTexture(image);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(nativeImage.getResourceLocation(), (Texture)nativeImage);
                return nativeImage;
                finally {
                    if (image != null) {
                        if (throwable != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            image.close();
                        }
                    }
                }
            });
            return nit != null ? nit.getResourceLocation() : null;
        }
        return null;
    }

    private void findMeta() {
        for (String note : this.project.notes) {
            if (note.startsWith("hats-rarity:")) {
                try {
                    this.forcedRarity = EnumRarity.valueOf(note.substring("hats-rarity:".length()).trim().toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    Hats.LOGGER.error("Cannot find Hat Rarity of {}", (Object)this.name);
                }
                continue;
            }
            if (note.startsWith("hats-pool:")) {
                this.forcedPool = note.substring("hats-pool:".length()).trim();
                continue;
            }
            if (note.startsWith("hats-worth:")) {
                try {
                    this.forcedWorth = Integer.parseInt(note.substring("hats-worth:".length()).trim());
                }
                catch (NumberFormatException e) {
                    Hats.LOGGER.error("Error parsing forced worth of hat: \"{}\" from project: {}", (Object)note, (Object)this.project.saveFile);
                }
                continue;
            }
            if (note.startsWith("hats-contributor-uuid:")) {
                this.contributorUUID = UUID.fromString(note.substring("hats-contributor-uuid:".length()).trim());
                continue;
            }
            if (note.startsWith("hats-contributor-mini-me:")) {
                if (this.contributorUUID != null) continue;
                this.contributorUUID = EntityHelper.UUID_EXAMPLE;
                continue;
            }
            if (note.startsWith("hats-accessory:")) {
                this.accessoryFor = note.substring("hats-accessory:".length()).trim();
                continue;
            }
            if (note.startsWith("hats-accessory-layer:")) {
                this.accessoryLayer.add(note.substring("hats-accessory-layer:".length()).trim());
                continue;
            }
            if (note.startsWith("hats-accessory-parent:")) {
                this.accessoryParent = note.substring("hats-accessory-parent:".length()).trim();
                continue;
            }
            if (note.startsWith("hats-accessory-hide-parent-part:")) {
                this.hideParent.add(note.substring("hats-accessory-hide-parent-part:".length()).trim());
                continue;
            }
            if (note.startsWith("hats-description:")) {
                this.description = note.substring("hats-description:".length()).trim();
                continue;
            }
            if (!note.startsWith("hat")) continue;
            Hats.LOGGER.warn("We found a hats meta we don't understand: {} in Project: {}", (Object)note, (Object)this.project.saveFile);
        }
    }

    public void accessorise(ArrayList<HatInfo> newAccessories) {
        this.accessories.addAll(newAccessories.stream().filter(info -> info.accessoryParent == null || info.accessoryParent.equals(this.name)).collect(Collectors.toList()));
        newAccessories.removeAll(this.accessories);
        if (this.forcedWorth >= 0) {
            this.worth = this.forcedWorth;
        }
        for (HatInfo accessory : this.accessories) {
            accessory.accessorise(newAccessories);
        }
    }

    public String getDisplayNameFor(String accessoryName) {
        HatInfo info = this.getInfoFor(accessoryName);
        return info != null ? info.getDisplayName() : null;
    }

    public HatInfo getInfoFor(String accessoryName) {
        if (accessoryName.equals(this.name)) {
            return this;
        }
        for (HatInfo accessory : this.accessories) {
            HatInfo s = accessory.getInfoFor(accessoryName);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public int getWorthFor(String accessoryName, int bonus) {
        if (accessoryName.equals(this.name)) {
            return this.getWorth() + bonus;
        }
        for (HatInfo accessory : this.accessories) {
            int s = accessory.getWorthFor(accessoryName, this.getWorth() + bonus);
            if (s <= 0) continue;
            return s;
        }
        return -1;
    }

    public HatsSavedData.HatPart getAsHatPart(int count) {
        HatsSavedData.HatPart part = new HatsSavedData.HatPart(this.name);
        part.isShowing = true;
        part.count = count;
        for (HatInfo accessory : this.accessories) {
            HatsSavedData.HatPart childPart = accessory.getAsHatPart(count);
            childPart.isShowing = false;
            part.hatParts.add(childPart);
        }
        return part;
    }

    public HatsSavedData.HatPart getFromList(ArrayList<String> names, int count) {
        HatsSavedData.HatPart hatPart = this.getAsHatPartShowingAll(count);
        hatPart.stripIfNameNotInList(names);
        return hatPart;
    }

    private HatsSavedData.HatPart getAsHatPartShowingAll(int count) {
        HatsSavedData.HatPart part = new HatsSavedData.HatPart(this.name);
        part.isShowing = true;
        part.count = count;
        for (HatInfo accessory : this.accessories) {
            HatsSavedData.HatPart childPart = accessory.getAsHatPartShowingAll(count);
            part.hatParts.add(childPart);
        }
        return part;
    }

    @Override
    public int compareTo(HatInfo o) {
        return this.name.compareTo(o.name);
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        if (this.accessoryFor != null) {
            sb.append(this.accessoryFor);
            sb.append(":");
        }
        if (this.accessoryParent != null) {
            sb.append(this.accessoryParent);
            sb.append("|");
        }
        sb.append(this.name);
        return sb.toString();
    }

    public void addFullNames(HashSet<String> names) {
        names.add(this.getFullName());
        for (HatInfo accessory : this.accessories) {
            accessory.addFullNames(names);
        }
    }

    public void addNameWithOrigin(ArrayList<String> names, String origin) {
        names.add(origin + ":" + this.name);
        for (HatInfo accessory : this.accessories) {
            accessory.addNameWithOrigin(names, origin);
        }
    }

    public void assignAccessoriesToPart(HatsSavedData.HatPart hatPart, LivingEntity ent) {
        ArrayList<HatInfo> spawningAccessories = new ArrayList<HatInfo>();
        HashMap<String, ArrayList> conflicts = new HashMap<String, ArrayList>();
        for (HatInfo accessory : this.accessories) {
            double accChance = Hats.configServer.rarityIndividual.get(accessory.getRarity().ordinal());
            HatHandler.RAND.setSeed((long)Math.abs((Hats.configServer.randSeed + ent.func_110124_au() + accessory.getFullName()).hashCode()) * 53579997854L);
            HeadInfo info = HeadHandler.getHelper(ent.getClass());
            if (info != null && info.isBoss.booleanValue()) {
                accChance += Hats.configServer.bossRarityBonus;
            }
            if (!(HatHandler.RAND.nextDouble() < accChance)) continue;
            spawningAccessories.add(accessory);
            if (accessory.accessoryLayer.isEmpty()) continue;
            for (String layer : accessory.accessoryLayer) {
                conflicts.computeIfAbsent(layer, k -> new ArrayList()).add(accessory);
            }
        }
        conflicts.entrySet().removeIf(entry -> ((ArrayList)entry.getValue()).size() <= 1);
        for (ArrayList conflictAccessories : conflicts.values()) {
            while (conflictAccessories.size() > 1) {
                HatInfo acc = (HatInfo)conflictAccessories.get(ent.func_70681_au().nextInt(conflictAccessories.size()));
                spawningAccessories.remove(acc);
                conflictAccessories.remove(acc);
            }
        }
        for (HatInfo accessory : spawningAccessories) {
            HatsSavedData.HatPart accToSpawn = new HatsSavedData.HatPart(accessory.name);
            accToSpawn.isShowing = true;
            hatPart.hatParts.add(accToSpawn);
            accessory.assignAccessoriesToPart(accToSpawn, ent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void assignAccessoriesToPartClient(HatsSavedData.HatPart hatPart, LivingEntity ent) {
        ArrayList<HatInfo> spawningAccessories = new ArrayList<HatInfo>();
        HashMap<String, ArrayList> conflicts = new HashMap<String, ArrayList>();
        HatHandler.RAND.setSeed((long)Math.abs((Minecraft.func_71410_x().func_110432_I().func_111285_a() + ent.func_110124_au()).hashCode()) * 53579997854L);
        for (HatInfo accessory : this.accessories) {
            if (!HatHandler.RAND.nextBoolean()) continue;
            spawningAccessories.add(accessory);
            if (accessory.accessoryLayer.isEmpty()) continue;
            for (String layer : accessory.accessoryLayer) {
                conflicts.computeIfAbsent(layer, k -> new ArrayList()).add(accessory);
            }
        }
        conflicts.entrySet().removeIf(entry -> ((ArrayList)entry.getValue()).size() <= 1);
        for (ArrayList conflictAccessories : conflicts.values()) {
            while (conflictAccessories.size() > 1) {
                HatInfo acc = (HatInfo)conflictAccessories.get(ent.func_70681_au().nextInt(conflictAccessories.size()));
                spawningAccessories.remove(acc);
                conflictAccessories.remove(acc);
            }
        }
        for (HatInfo accessory : spawningAccessories) {
            HatsSavedData.HatPart accToSpawn = new HatsSavedData.HatPart(accessory.name);
            accToSpawn.isShowing = true;
            hatPart.hatParts.add(accToSpawn);
            accessory.assignAccessoriesToPartClient(accToSpawn, ent);
        }
    }

    public void matchPart(HatsSavedData.HatPart part) {
        int i;
        for (HatInfo accessory : this.accessories) {
            accessory.hidden = true;
            for (HatsSavedData.HatPart hatPart : part.hatParts) {
                if (!hatPart.name.equals(accessory.name)) continue;
                accessory.matchPart(hatPart);
            }
        }
        this.hidden = part.count < 0 || !part.isShowing;
        for (i = 0; i < part.colouriser.length; ++i) {
            this.colouriser[i] = 1.0f - part.colouriser[i];
        }
        for (i = 0; i < part.hsbiser.length; ++i) {
            this.hsbiser[i] = 1.0f - part.hsbiser[i];
        }
        this.enchanted = part.enchanted;
    }

    public float[] getDimensions() {
        if (this.hidden) {
            return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        }
        float x1 = 10000.0f;
        float x2 = -10000.0f;
        float z1 = 10000.0f;
        float z2 = -10000.0f;
        float y1 = 10000.0f;
        float y2 = -10000.0f;
        for (Project.Part part : this.allParts) {
            for (Project.Part.Box box : part.boxes) {
                if (part.rotPX + box.posX < x1) {
                    x1 = part.rotPX + box.posX;
                }
                if (part.rotPX + box.posX + box.dimX > x2) {
                    x2 = part.rotPX + box.posX + box.dimX;
                }
                if (part.rotPZ + box.posZ < z1) {
                    z1 = part.rotPZ + box.posZ;
                }
                if (part.rotPZ + box.posZ + box.dimZ > z2) {
                    z2 = part.rotPZ + box.posZ + box.dimZ;
                }
                if (part.rotPY + box.posY < y1) {
                    y1 = part.rotPY + box.posY;
                }
                if (!(part.rotPY + box.posY + box.dimY > y2)) continue;
                y2 = part.rotPY + box.posY + box.dimY;
            }
        }
        float[] dims = new float[]{x1, x2, y1, y2, z1, z2};
        for (HatInfo accessory : this.accessories) {
            float[] accDims = accessory.getDimensions();
            for (int i = 0; i < accDims.length; ++i) {
                if (i % 2 == 0) {
                    if (!(accDims[i] < dims[i])) continue;
                    dims[i] = accDims[i];
                    continue;
                }
                if (!(accDims[i] > dims[i])) continue;
                dims[i] = accDims[i];
            }
        }
        return dims;
    }
}

