/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.hats.EnumRarity;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.hats.sort.HatSorter;
import me.ichun.mods.hats.common.world.HatsSavedData;

public class SorterRarity
extends HatSorter {
    @Override
    @Nonnull
    public String type() {
        return "sorterRarity";
    }

    @Override
    public void sort(List hats) {
        EnumRarity[] rarities;
        ArrayList<HatsSavedData.HatPart> unsorted = new ArrayList<HatsSavedData.HatPart>();
        EnumMap<EnumRarity, ArrayList> hatsByRarity = new EnumMap<EnumRarity, ArrayList>(EnumRarity.class);
        for (Object o : hats) {
            HatsSavedData.HatPart hat = (HatsSavedData.HatPart)o;
            HatInfo info = HatResourceHandler.getInfo(hat);
            if (info != null) {
                hatsByRarity.computeIfAbsent(info.getRarity(), k -> new ArrayList()).add(hat);
                continue;
            }
            unsorted.add(hat);
        }
        hats.clear();
        for (EnumRarity rarity : rarities = EnumRarity.values()) {
            if (!hatsByRarity.containsKey((Object)rarity)) continue;
            hats.add(hatsByRarity.get((Object)rarity));
        }
        if (this.isInverse) {
            Collections.reverse(hats);
        }
        hats.add(unsorted);
    }
}

