/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.toast.Toast;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.ichunutil.common.network.PacketDataFragment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHatFragment
extends PacketDataFragment {
    public String origin;
    public String md5;

    public PacketHatFragment() {
    }

    public PacketHatFragment(String fileName, int packetTotal, int packetNumber, byte[] data, String origin, String md5) {
        super(fileName, packetTotal, packetNumber, data);
        this.origin = origin;
        this.md5 = md5;
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_180714_a(this.origin);
        buf.func_180714_a(this.md5);
        super.writeTo(buf);
    }

    public void readFrom(PacketBuffer buf) {
        this.origin = this.readString(buf);
        this.md5 = this.readString(buf);
        super.readFrom(buf);
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            if (Hats.configServer.allowFileTransfer) {
                byte[] data = this.process(context.getDirection().getReceptionSide());
                if (data != null) {
                    try {
                        Path saveDir = HatResourceHandler.getHatsDir().resolve("Received").resolve(this.origin).resolve(this.md5);
                        if (!Files.exists(saveDir, new LinkOption[0])) {
                            Files.createDirectories(saveDir, new FileAttribute[0]);
                        }
                        File hatFile = new File(saveDir.toFile(), this.fileName);
                        FileOutputStream fos = new FileOutputStream(hatFile);
                        fos.write(data);
                        fos.close();
                        HatResourceHandler.loadSingularHat(hatFile);
                        HatHandler.allocateHatPools();
                        if (FMLEnvironment.dist.isClient()) {
                            this.handleClient();
                        }
                    }
                    catch (Exception e) {
                        Hats.LOGGER.error("Error writing received hat {} from {}", (Object)this.fileName, (Object)this.origin);
                        e.printStackTrace();
                    }
                }
            } else {
                Hats.LOGGER.warn("Received file fragment from {} despite config being disabled.", (Object)this.origin);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Hats.eventHandlerClient.resetSyncToast();
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new Toast((ITextComponent)new TranslationTextComponent("hats.toast.sync.receivedHat"), (ITextComponent)new StringTextComponent(this.fileName.substring(0, this.fileName.length() - 4)), 2));
        if (Minecraft.func_71410_x().field_71462_r instanceof WorkspaceHats) {
            ((WorkspaceHats)Minecraft.func_71410_x().field_71462_r).refreshHats();
        }
    }
}

