/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableCenter;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class VoxelShapeComponentsFactoryHandlerCableConnections
implements VoxelShapeComponentsFactory.IHandler {
    private static final EnumFacingMap<VoxelShape> BOUNDS = EnumFacingMap.forAllValues((Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625)), (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625)), (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375)), (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0)), (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625)), (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)));

    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, IBlockReader world, BlockPos blockPos) {
        ArrayList components = Lists.newArrayList();
        if (CableHelpers.isNoFakeCable(world, blockPos, null)) {
            for (Direction direction : Direction.values()) {
                IPartContainer partContainer = null;
                if (!CableHelpers.isCableConnected(world, blockPos, direction) && ((partContainer = (IPartContainer)PartHelpers.getPartContainer(world, blockPos, direction).orElse(null)) == null || !partContainer.hasPart(direction))) continue;
                components.add(new Component(direction, partContainer));
            }
        }
        return components;
    }

    public static class Component
    extends VoxelShapeComponentsFactoryHandlerCableCenter.Component {
        private final Direction direction;
        @Nullable
        private final IPartContainer partContainer;

        public Component(Direction direction, @Nullable IPartContainer partContainer) {
            this.direction = direction;
            this.partContainer = partContainer;
        }

        @Override
        public String getStateId(BlockState blockState, IBlockReader world, BlockPos blockPos) {
            return "conn(" + this.direction.ordinal() + ")";
        }

        @Override
        public VoxelShape getShape(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
            if (this.partContainer == null) {
                return (VoxelShape)BOUNDS.get((Object)this.direction);
            }
            IPartType part = this.partContainer.getPart(this.direction);
            if (part == null) {
                return (VoxelShape)BOUNDS.get((Object)this.direction);
            }
            return part.getPartRenderPosition().getSidedCableBoundingBox(this.direction);
        }

        @Override
        public ActionResultType onBlockActivated(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.func_184586_b(hand);
            ActionResultType actionResult = CableHelpers.onCableActivated(world, blockPos, state, player, heldItem, hit.func_216354_b(), this.direction);
            if (actionResult.func_226246_a_()) {
                return actionResult;
            }
            return ActionResultType.PASS;
        }
    }
}

