/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyMaterializedFactory
implements IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<IValueType<IValue>, IValue, ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integrateddynamics", "materialized");
    }

    @Override
    public INBT serialize(ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> values) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        Object valueType = values.getValueType();
        boolean heterogeneous = false;
        try {
            if (valueType.isCategory() && values.getLength() > 0) {
                heterogeneous = true;
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        tag.func_74778_a("valueType", valueType.getUniqueName().toString());
        tag.func_218657_a("values", (INBT)list);
        for (IValue value : values) {
            INBT valueSerialized = ValueHelpers.serializeRaw(value);
            if (heterogeneous) {
                CompoundNBT valueTag = new CompoundNBT();
                valueTag.func_74778_a("valueType", value.getType().getUniqueName().toString());
                valueTag.func_218657_a("value", valueSerialized);
                list.add((Object)valueTag);
                continue;
            }
            list.add((Object)valueSerialized);
        }
        return tag;
    }

    @Override
    public ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> deserialize(INBT value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        if (!(value instanceof CompoundNBT)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is not a CompoundNBT.", value));
        }
        CompoundNBT tag = (CompoundNBT)value;
        if (!tag.func_150297_b("valueType", 8)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is missing a valueType.", value));
        }
        if (!tag.func_150297_b("values", 9)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is missing values.", value));
        }
        String valueTypeName = tag.func_74779_i("valueType");
        IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(valueTypeName));
        if (valueType == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", valueTypeName));
        }
        boolean heterogeneous = valueType.isCategory();
        IValueType elementValueType = valueType;
        ImmutableList.Builder builder = ImmutableList.builder();
        ListNBT list = (ListNBT)tag.func_74781_a("values");
        for (INBT valueTag : list) {
            INBT valueSerialized;
            if (heterogeneous) {
                String subValueTypeName = ((CompoundNBT)valueTag).func_74779_i("valueType");
                elementValueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(subValueTypeName));
                if (elementValueType == null) {
                    throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", subValueTypeName));
                }
                valueSerialized = ((CompoundNBT)valueTag).func_74781_a("value");
            } else {
                valueSerialized = valueTag;
            }
            Object deserializedValue = ValueHelpers.deserializeRaw(elementValueType, valueSerialized);
            builder.add(deserializedValue);
        }
        return new ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>(valueType, (List<IValue>)builder.build());
    }
}

