/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class EnergyHelpers {
    private static final List<IEnergyStorageProxy> ENERGY_STORAGE_PROXIES = Lists.newArrayList();

    public static void addEnergyStorageProxy(IEnergyStorageProxy energyStorageProxy) {
        ENERGY_STORAGE_PROXIES.add(energyStorageProxy);
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(PartPos pos) {
        return EnergyHelpers.getEnergyStorage(pos.getPos(), pos.getSide());
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(DimPos pos, Direction facing) {
        World world = pos.getWorld(true);
        return world != null ? EnergyHelpers.getEnergyStorage((IBlockReader)world, pos.getBlockPos(), facing) : LazyOptional.empty();
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(IBlockReader world, BlockPos pos, Direction facing) {
        IEnergyStorage energyStorage = (IEnergyStorage)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)facing, (Capability)CapabilityEnergy.ENERGY).orElseGet(() -> {
            for (IEnergyStorageProxy energyStorageProxy : ENERGY_STORAGE_PROXIES) {
                LazyOptional<IEnergyStorage> optionalEnergyStorage = energyStorageProxy.getEnergyStorageProxy(world, pos, facing);
                if (!optionalEnergyStorage.isPresent()) continue;
                return (IEnergyStorage)optionalEnergyStorage.orElse(null);
            }
            return null;
        });
        return energyStorage == null ? LazyOptional.empty() : LazyOptional.of(() -> energyStorage);
    }

    public static int fillNeigbours(World world, BlockPos pos, int energy, boolean simulate) {
        int toFill = energy;
        for (Direction side : Direction.values()) {
            IEnergyStorage energyStorage = (IEnergyStorage)EnergyHelpers.getEnergyStorage((IBlockReader)world, pos.func_177972_a(side), side.func_176734_d()).orElse(null);
            if (energyStorage == null || (toFill -= energyStorage.receiveEnergy(toFill, simulate)) > 0) continue;
            return energy;
        }
        return energy - toFill;
    }

    public static interface IEnergyStorageProxy {
        public LazyOptional<IEnergyStorage> getEnergyStorageProxy(IBlockReader var1, BlockPos var2, Direction var3);
    }
}

