/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

@OnlyIn(value=Dist.CLIENT)
class ValueTypeRecipeLPElementPropertiesSubGui
extends RenderPattern<ValueTypeRecipeLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final int slotId;
    private ButtonCheckbox inputNbt;
    private ButtonCheckbox inputTags;
    private WidgetTextFieldDropdown<ResourceLocation> inputTagsDropdown;
    private ButtonImage inputSave;

    public ValueTypeRecipeLPElementPropertiesSubGui(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container, int slotId) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.slotId = slotId;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.inputNbt = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 2, 110, 10, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.recipe.strictnbt"), entry -> {
            if (this.inputNbt.isChecked()) {
                this.inputTags.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
        });
        this.inputTags = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 12, 110, 10, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.recipe.tagvariants"), entry -> {
            if (this.inputTags.isChecked()) {
                this.inputNbt.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
            if (this.inputTags.isChecked()) {
                this.inputTagsDropdown.func_146195_b(true);
            }
        });
        this.inputTagsDropdown = new WidgetTextFieldDropdown(Minecraft.func_71410_x().field_71466_p, guiLeft + this.getX() + 2, guiTop + this.getY() + 23, 134, 14, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.search"), true, Sets.newHashSet());
        this.inputTagsDropdown.setDropdownEntryListener(entry -> this.saveGuiToState());
        this.inputTagsDropdown.func_146203_f(64);
        this.inputTagsDropdown.setDropdownSize(4);
        this.inputTagsDropdown.func_146185_a(false);
        this.inputTagsDropdown.func_146193_g(0xFFFFFF);
        this.inputTagsDropdown.func_146205_d(true);
        this.inputSave = new ButtonImage(guiLeft + this.getX() + 116, guiTop + this.getY() + 72, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.button.save"), button -> {
            if (!this.inputTags.isChecked() || this.inputTagsDropdown.getSelectedDropdownPossibility() != null) {
                ((ValueTypeRecipeLPElement)this.element).lastGui.setRecipeSubGui();
            } else {
                this.inputTagsDropdown.func_146195_b(true);
            }
        }, (IImage)Images.OK);
        this.loadStateToGui();
        if (this.inputTags.isChecked()) {
            this.inputTagsDropdown.func_146195_b(true);
        }
    }

    public ItemStack getSlotContents() {
        return ((Slot)((ContainerLogicProgrammerBase)this.container).field_75151_b.get(this.slotId + 4)).func_75211_c();
    }

    public ItemMatchProperties getSlotProperties() {
        return (ItemMatchProperties)((ValueTypeRecipeLPElement)this.getElement()).getInputStacks().get(this.slotId);
    }

    private Set<IDropdownEntry<ResourceLocation>> getDropdownEntries() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        if (this.getSlotContents().func_190926_b()) {
            for (ResourceLocation registeredTag : ItemTags.func_199903_a().func_199908_a()) {
                set.add(new DropdownEntry(registeredTag));
            }
        } else {
            for (ResourceLocation registeredTag : ItemTags.func_199903_a().func_199913_a((Object)this.getSlotContents().func_77973_b())) {
                set.add(new DropdownEntry(registeredTag));
            }
        }
        return set;
    }

    public void loadStateToGui() {
        ItemMatchProperties props = this.getSlotProperties();
        this.inputNbt.setChecked(props.isNbt());
        this.inputTags.setChecked(props.getItemTag() != null);
        this.inputTagsDropdown.func_146189_e(this.inputTags.isChecked());
        if (this.inputTags.isChecked()) {
            Set dropdownEntries = this.getDropdownEntries();
            this.inputTagsDropdown.setPossibilities(dropdownEntries);
            if (props.getItemTag() != null) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.stream().filter(e -> e.getMatchString().equals(props.getItemTag())).findFirst().orElse(null));
            } else if (!dropdownEntries.isEmpty()) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.iterator().next());
            } else {
                this.inputTagsDropdown.selectPossibility(null);
            }
        } else {
            this.inputTagsDropdown.func_146180_a("");
            this.inputTagsDropdown.setPossibilities(Collections.emptySet());
        }
    }

    public void saveGuiToState() {
        boolean nbt = this.inputNbt.isChecked();
        String tag = this.inputTags.isChecked() ? this.inputTagsDropdown.func_146179_b() : null;
        this.getSlotProperties().setNbt(nbt);
        this.getSlotProperties().setItemTag(tag);
        ((ValueTypeRecipeLPElement)this.element).sendSlotPropertiesToServer(this.slotId, this.getSlotProperties());
    }

    @Override
    protected boolean drawRenderPattern() {
        return false;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.drawSlot(matrixStack, this.getX() + guiLeft + 116, this.getY() + guiTop + 2);
        this.inputNbt.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        fontRenderer.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.recipe.strictnbt", (Object[])new Object[0]), (float)(guiLeft + this.getX() + 24), (float)(guiTop + this.getY() + 3), 0);
        this.inputTags.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        fontRenderer.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.recipe.tagvariants", (Object[])new Object[0]), (float)(guiLeft + this.getX() + 24), (float)(guiTop + this.getY() + 13), 0);
        this.inputSave.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.inputTagsDropdown.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
        int i;
        super.drawGuiContainerForegroundLayer(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        if (this.inputTagsDropdown.func_230999_j_() && (i = this.inputTagsDropdown.getHoveredVisiblePossibility(mouseX, mouseY)) >= 0) {
            IDropdownEntry<ResourceLocation> hoveredPossibility = this.inputTagsDropdown.getVisiblePossibility(i);
            this.drawTagsTooltip(hoveredPossibility, guiLeft, guiTop, mouseX + 10, mouseY - 20, 6, GuiHelpers.SLOT_SIZE);
        }
    }

    protected void drawTagsTooltip(IDropdownEntry<ResourceLocation> hoveredPossibility, int guiLeft, int guiTop, int mouseX, int mouseY, int columns, int offset) {
        int x = mouseX - guiLeft;
        int y = mouseY - guiTop;
        List items = ItemTags.func_199903_a().func_199910_a(hoveredPossibility.getValue()).func_230236_b_();
        GuiHelpers.drawTooltipBackground((int)x, (int)y, (int)(Math.min(items.size(), columns) * offset), (int)(((items.size() % columns == 0 ? 0 : 1) + items.size() / columns) * offset));
        int passed = 0;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        itemRenderer.field_77023_b = 300.0f;
        for (Item item : items) {
            itemRenderer.func_180450_b(new ItemStack((IItemProvider)item), x, y);
            x += offset;
            if (passed++ % columns != columns - 1) continue;
            y += offset;
            x = mouseX - guiLeft;
        }
        itemRenderer.field_77023_b = 0.0f;
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.inputTagsDropdown.func_230999_j_() && this.inputTagsDropdown.func_231042_a_(typedChar, keyCode)) {
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.inputTagsDropdown.func_230999_j_()) {
            this.inputTagsDropdown.func_231046_a_(typedChar, keyCode, modifiers);
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.inputNbt.func_231044_a_(mouseX, mouseY, mouseButton) || this.inputTags.func_231044_a_(mouseX, mouseY, mouseButton) || this.inputTagsDropdown.func_231044_a_(mouseX, mouseY, mouseButton) || this.inputSave.func_231044_a_(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public static class DropdownEntry
    implements IDropdownEntry<ResourceLocation> {
        private final ResourceLocation tag;

        public DropdownEntry(ResourceLocation tag) {
            this.tag = tag;
        }

        @Override
        public String getMatchString() {
            return this.tag.toString();
        }

        @Override
        public IFormattableTextComponent getDisplayString() {
            return new StringTextComponent(this.tag.toString());
        }

        @Override
        public List<IFormattableTextComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public ResourceLocation getValue() {
            return this.tag;
        }
    }
}

