/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.valueinterface.ValueInterfaceConfig;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;

public abstract class TileActiveVariableBase<E>
extends TileCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<E> {
    private final InventoryVariableEvaluator<IValue> evaluator;

    public TileActiveVariableBase(TileEntityType<?> type, int inventorySize) {
        super(type, inventorySize, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(ValueInterfaceConfig.CAPABILITY, LazyOptional.of(() -> () -> {
            IVariable<?> variable;
            INetwork network = this.getNetwork();
            IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
            if (this.hasVariable() && (variable = this.getVariable(partNetwork)) != null) {
                return Optional.of(variable.getValue());
            }
            return Optional.empty();
        }));
        this.evaluator = this.createEvaluator();
    }

    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((IInventory)this.getInventory(), this.getSlotRead(), ValueTypes.CATEGORY_ANY);
    }

    public InventoryVariableEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        List<IFormattableTextComponent> errors = this.evaluator.getErrors();
        NBTClassType.writeNbt(List.class, (String)"errors", errors, (CompoundNBT)tag);
        return super.func_189515_b(tag);
    }

    @Override
    public void read(CompoundNBT tag) {
        this.evaluator.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors", (CompoundNBT)tag));
        super.read(tag);
    }

    public abstract int getSlotRead();

    public boolean hasVariable() {
        return !this.getInventory().func_70301_a(this.getSlotRead()).func_190926_b();
    }

    protected void updateReadVariable(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.getNetwork(), sendVariablesUpdateEvent);
        this.sendUpdate();
    }

    public void onDirty() {
        if (!this.field_145850_b.func_201670_d()) {
            this.updateReadVariable(true);
        }
    }

    @Nullable
    public IVariable<?> getVariable(IPartNetwork network) {
        return this.evaluator.getVariable(network);
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, E networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.updateReadVariable(false);
        }
    }

    @Override
    public void afterNetworkReAlive() {
        super.afterNetworkReAlive();
        this.updateReadVariable(true);
    }
}

