/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.recipe;

import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;

public class ItemFacadeRecipe
extends SpecialRecipe {
    private NonNullList<Ingredient> ingredients;

    public ItemFacadeRecipe(ResourceLocation id) {
        super(id);
    }

    public NonNullList<Ingredient> func_192400_c() {
        if (this.ingredients == null) {
            try {
                this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.func_77571_b()}), new BlocksIngredient()});
            }
            catch (RuntimeException e) {
                return NonNullList.func_191196_a();
            }
        }
        return this.ingredients;
    }

    public boolean matches(CraftingInventory grid, World world) {
        return !this.getCraftingResult(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)RegistryEntries.ITEM_FACADE);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        int facades = 0;
        ItemStack block = ItemStack.field_190927_a;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            if (element.func_77973_b() == output.func_77973_b()) {
                ++facades;
                continue;
            }
            if (block.func_190926_b() && element.func_77973_b() instanceof BlockItem) {
                block = element;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (facades != 1 || block.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        RegistryEntries.ITEM_FACADE.writeFacadeBlock(output, BlockHelpers.getBlockStateFromItemStack((ItemStack)block));
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_FACADE;
    }

    public static class BlocksIngredient
    extends Ingredient {
        protected BlocksIngredient() {
            super(ForgeRegistries.BLOCKS.getValues().stream().map(ItemStack::new).map(Ingredient.SingleItemList::new));
        }

        public boolean test(@Nullable ItemStack itemStack) {
            return itemStack != null && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof BlockItem;
        }
    }
}

