/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.JEIIntegratedDynamicsConfig;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeJEI;

public class MechanicalSqueezerRecipeCategory
implements IRecipeCategory<MechanicalSqueezerRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("integrateddynamicscompat", "mechanical_squeezer");
    private static final int INPUT_SLOT = 0;
    private static final int FLUIDOUTPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrowDrawable;

    public MechanicalSqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/mechanical_squeezer_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER));
        this.arrowDrawable = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(resourceLocation, 116, 0, 4, 11), 20, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends MechanicalSqueezerRecipeJEI> getRecipeClass() {
        return MechanicalSqueezerRecipeJEI.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent(RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.func_149739_a()).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MechanicalSqueezerRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItem());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems().stream().map(RecipeSqueezer.ItemStackChance::getItemStack).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, MechanicalSqueezerRecipeJEI recipe, IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, true, 1, 17);
        int offset = 0;
        for (i = 0; i < recipe.getOutputItems().size(); ++i) {
            recipeLayout.getItemStacks().init(2 + i, false, 75 + (i % 2 > 0 ? 22 : 0), 7 + offset + (i > 1 ? 22 : 0));
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex >= 2 && slotIndex < 2 + recipe.getOutputItems().size()) {
                float chance = ((RecipeSqueezer.ItemStackChance)recipe.getOutputItems().get(slotIndex - 2)).getChance();
                tooltip.add(new StringTextComponent("Chance: " + chance * 100.0f + "%").func_240699_a_(TextFormatting.GRAY));
            }
        });
        if (!recipe.getInputItem().isEmpty()) {
            recipeLayout.getItemStacks().set(0, recipe.getInputItem());
        }
        i = 0;
        for (RecipeSqueezer.ItemStackChance outputItem : recipe.getOutputItems()) {
            recipeLayout.getItemStacks().set(2 + i++, outputItem.getItemStack());
        }
        recipeLayout.getFluidStacks().init(1, false, 98, 30, 16, 16, 1000, false, null);
        if (!recipe.getOutputFluid().isEmpty()) {
            recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
        }
    }

    public void draw(MechanicalSqueezerRecipeJEI recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrowDrawable.draw(matrixStack, 45, 21);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent energy = JEIIntegratedDynamicsConfig.getEnergyTextComponent(recipe.getDuration(), BlockMechanicalDryingBasinConfig.consumptionRate);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)energy, (float)((this.background.getWidth() - fontRenderer.func_238414_a_((ITextProperties)energy)) / 2 - 10), 0.0f, -8355712);
        IFormattableTextComponent duration = JEIIntegratedDynamicsConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)duration, (float)((this.background.getWidth() - fontRenderer.func_238414_a_((ITextProperties)duration)) / 2 - 10), 42.0f, -8355712);
    }
}

