/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.physics.PhysicsAccummulator;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.util.RealBB;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EntityCoupleableRollingStock
extends EntityMoveableRollingStock {
    private boolean resimulate = false;
    private int resimulateCooldown = 0;
    public boolean isAttaching = false;
    @TagField(value="CoupledFront")
    private UUID coupledFront = null;
    @TagField(value="lastKnownFront")
    private Vec3i lastKnownFront = null;
    @TagField(value="frontCouplerEngaged")
    private boolean frontCouplerEngaged = true;
    private Vec3d couplerFrontPosition = null;
    @TagField(value="CoupledBack")
    private UUID coupledBack = null;
    @TagField(value="lastKnownRear")
    private Vec3i lastKnownRear = null;
    @TagField(value="backCouplerEngaged")
    private boolean backCouplerEngaged = true;
    private Vec3d couplerRearPosition = null;

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_HOOK) && this.getWorld().isServer) {
            CouplerType coupler = CouplerType.FRONT;
            if (this.getCouplerPosition(CouplerType.FRONT).distanceTo(player.getPosition()) > this.getCouplerPosition(CouplerType.BACK).distanceTo(player.getPosition())) {
                coupler = CouplerType.BACK;
            }
            if (player.isCrouching()) {
                this.setCouplerEngaged(coupler, !this.isCouplerEngaged(coupler));
                if (this.isCouplerEngaged(coupler)) {
                    player.sendMessage(ChatText.COUPLER_ENGAGED.getMessage(new Object[]{coupler}));
                } else {
                    player.sendMessage(ChatText.COUPLER_DISENGAGED.getMessage(new Object[]{coupler}));
                }
            } else if (this.isCoupled(coupler) && this.isCouplerEngaged(coupler)) {
                EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
                player.sendMessage(ChatText.COUPLER_STATUS_COUPLED.getMessage(new Object[]{coupler, coupled.getDefinition().name(), coupled.getPosition().x, coupled.getPosition().y, coupled.getPosition().z}));
            } else if (this.isCouplerEngaged(coupler)) {
                player.sendMessage(ChatText.COUPLER_STATUS_DECOUPLED_ENGAGED.getMessage(new Object[]{coupler}));
            } else {
                player.sendMessage(ChatText.COUPLER_STATUS_DECOUPLED_DISENGAGED.getMessage(new Object[]{coupler}));
            }
            return ClickResult.ACCEPTED;
        }
        return super.onClick(player, hand);
    }

    @Override
    public void onTick() {
        super.onTick();
        World world = this.getWorld();
        if (world.isClient) {
            return;
        }
        if (this.resimulateCooldown > 0) {
            --this.resimulateCooldown;
        }
        if (this.getCurrentSpeed().minecraft() != 0.0 || Config.ConfigDebug.keepStockLoaded) {
            world.keepLoaded(this.getBlockPosition());
            world.keepLoaded(new Vec3i(this.guessCouplerPosition(CouplerType.FRONT)));
            world.keepLoaded(new Vec3i(this.guessCouplerPosition(CouplerType.BACK)));
            if (this.lastKnownFront != null) {
                world.keepLoaded(this.lastKnownFront);
            }
            if (this.lastKnownRear != null) {
                world.keepLoaded(this.lastKnownRear);
            }
        }
        for (CouplerType coupler : CouplerType.values()) {
            CouplerType otherCoupler;
            if (!this.isCoupled(coupler)) continue;
            EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
            if (coupled == null) {
                if (this.getTickCount() <= 20) continue;
                ImmersiveRailroading.warn((String)"Coupled entity was not loaded after 20 ticks, decoupling", (Object[])new Object[0]);
                this.decouple(coupler);
                continue;
            }
            if (coupled.isDead()) {
                ImmersiveRailroading.warn((String)"Removing Dead Stock", (Object[])new Object[0]);
                this.decouple(coupler);
                continue;
            }
            if (coupler == CouplerType.FRONT) {
                this.lastKnownFront = coupled.getBlockPosition();
            } else {
                this.lastKnownRear = coupled.getBlockPosition();
            }
            if (this.isCouplerEngaged(coupler) || (otherCoupler = coupled.getCouplerFor(this)) == null || !(this.getCouplerPosition(coupler).distanceTo(coupled.getCouplerPosition(otherCoupler)) > Config.ConfigDebug.couplerRange * 4.0)) continue;
            this.decouple(coupled);
        }
        for (CouplerType coupler : CouplerType.values()) {
            Pair<EntityCoupleableRollingStock, CouplerType> potential;
            if (this.isCoupled(coupler) || (potential = this.potentialCouplings(coupler)) == null) continue;
            EntityCoupleableRollingStock stock = (EntityCoupleableRollingStock)((Object)potential.getLeft());
            CouplerType otherCoupler = (CouplerType)((Object)potential.getRight());
            this.setCoupledUUID(coupler, stock.getUUID());
            stock.setCoupledUUID(otherCoupler, this.getUUID());
            if (!stock.isCouplerEngaged(otherCoupler) || !this.isCouplerEngaged(coupler)) continue;
            new SoundPacket("immersiverailroading:sounds/default/coupling.ogg", this.getCouplerPosition(coupler), this.getVelocity(), 1.0f, 1.0f, 200, this.gauge).sendToObserving((Entity)this);
        }
    }

    private Vec3d guessCouplerPosition(CouplerType coupler) {
        return this.getPosition().add(VecUtil.fromWrongYaw(this.getDefinition().getLength(this.gauge) / 2.0 * (double)(coupler == CouplerType.FRONT ? 1 : -1), this.getRotationYaw()));
    }

    public void tickPosRemainingCheck() {
        if (this.getRemainingPositions() < 10 || this.resimulate) {
            TickPos lastPos = this.getCurrentTickPosAndPrune();
            if (lastPos == null) {
                this.triggerResimulate();
                return;
            }
            if (this.resimulate && this.getTickCount() % 5 != 0) {
                return;
            }
            this.simulateCoupledRollingStock();
        }
    }

    private Speed getMovement(TickPos currentPos, boolean followStock) {
        PhysicsAccummulator acc = new PhysicsAccummulator(currentPos);
        this.mapTrain(this, true, followStock, acc::accumulate);
        return acc.getVelocity();
    }

    private Speed getMovement(TickPos currentPos, Collection<DirectionalStock> train) {
        PhysicsAccummulator acc = new PhysicsAccummulator(currentPos);
        for (DirectionalStock stock : train) {
            acc.accumulate(stock.stock, stock.direction);
        }
        return acc.getVelocity();
    }

    public void simulateCoupledRollingStock() {
        TickPos lastPos = this.getCurrentTickPosAndPrune();
        this.positions = new ArrayList();
        this.positions.add(lastPos);
        Collection<DirectionalStock> train = this.getDirectionalTrain(true);
        Speed simSpeed = this.getCurrentSpeed();
        boolean isStuck = false;
        for (DirectionalStock stock : train) {
            if (stock.stock.areWheelsBuilt()) continue;
            isStuck = true;
        }
        for (int tickOffset = 1; tickOffset < 30; ++tickOffset) {
            simSpeed = this.getMovement((TickPos)this.positions.get(tickOffset - 1), train);
            if (isStuck) {
                simSpeed = Speed.ZERO;
            }
            TickPos pos = this.moveRollingStock(simSpeed.minecraft(), lastPos.tickID + tickOffset - 1);
            this.positions.add(pos);
            for (DirectionalStock stock : train) {
                if (stock.stock.getUUID().equals(this.getUUID())) continue;
                isStuck &= !stock.stock.simulateMove(stock.prev, tickOffset);
            }
        }
        for (DirectionalStock entity : train) {
            new MRSSyncPacket(entity.stock, entity.stock.positions).sendToObserving((Entity)entity.stock);
            entity.stock.resimulate = false;
        }
    }

    private boolean simulateMove(EntityCoupleableRollingStock parent, int tickOffset) {
        double dist;
        double prevDist;
        boolean onTrack;
        if (this.positions.size() < tickOffset) {
            ImmersiveRailroading.debug((String)("MISSING START POS " + tickOffset), (Object[])new Object[0]);
            return true;
        }
        TickPos currentPos = (TickPos)this.positions.get(tickOffset - 1);
        if (parent.positions.size() <= tickOffset) {
            return currentPos.isOffTrack;
        }
        TickPos parentPos = (TickPos)parent.positions.get(tickOffset);
        boolean bl = onTrack = !currentPos.isOffTrack;
        if (tickOffset == 1) {
            this.positions = new ArrayList();
            this.positions.add(currentPos);
        }
        CouplerType coupler = this.getCouplerFor(parent);
        CouplerType otherCoupler = parent.getCouplerFor(this);
        if (coupler == null) {
            parent.decouple(this);
            this.decouple(parent);
            ImmersiveRailroading.warn((String)"COUPLER NULL", (Object[])new Object[0]);
            return onTrack;
        }
        if (!(this.isCouplerEngaged(coupler) && parent.isCouplerEngaged(otherCoupler) || this.getTickCount() <= 5 || parent.getTickCount() <= 5 || parent.positions.size() < 2 || !((prevDist = currentPos.position.distanceTo(((TickPos)parent.positions.get((int)(tickOffset - 1))).position)) <= (dist = currentPos.position.distanceTo(((TickPos)parent.positions.get((int)tickOffset)).position))))) {
            TickPos nextPos = this.moveRollingStock(this.getMovement(currentPos, false).minecraft(), currentPos.tickID);
            this.positions.add(nextPos);
            if (nextPos.isOffTrack) {
                onTrack = false;
            }
            return onTrack;
        }
        Vec3d myOffset = this.getCouplerPositionTo(coupler, currentPos, parentPos);
        Vec3d otherOffset = parent.getCouplerPositionTo(otherCoupler, parentPos, currentPos);
        if (otherOffset == null) {
            if (this.getWorld().isServer) {
                ImmersiveRailroading.warn((String)String.format("Broken Coupling %s => %s", this.getUUID(), parent.getUUID()), (Object[])new Object[0]);
            }
            return onTrack;
        }
        double distance = myOffset.distanceTo(otherOffset);
        if (distance - Math.abs(currentPos.speed.minecraft()) > this.gauge.scale() * 20.0) {
            ImmersiveRailroading.warn((String)"Decoupling stock that are too far apart!", (Object[])new Object[0]);
            this.decouple();
            distance = Math.abs(parentPos.speed.minecraft());
        }
        Vec3d nextPosForward = myOffset.add(VecUtil.fromWrongYaw(distance, currentPos.rotationYaw));
        Vec3d nextPosReverse = myOffset.add(VecUtil.fromWrongYaw(-distance, currentPos.rotationYaw));
        if (otherOffset.distanceTo(nextPosForward) > otherOffset.distanceTo(nextPosReverse)) {
            distance = -distance;
        }
        TickPos nextPos = this.moveRollingStock(distance, currentPos.tickID);
        this.positions.add(nextPos);
        if (nextPos.isOffTrack) {
            onTrack = false;
        }
        if (nextPos.speed.metric() != 0.0) {
            this.getWorld().keepLoaded(new Vec3i(nextPos.position));
            for (CouplerType toChunk : CouplerType.values()) {
                this.getWorld().keepLoaded(new Vec3i(this.getCouplerPosition(toChunk, nextPos)));
            }
        }
        return onTrack;
    }

    public final void setCoupledUUID(CouplerType coupler, UUID id) {
        if (id != null && id.equals(this.getCoupledUUID(coupler))) {
            return;
        }
        switch (coupler) {
            case FRONT: {
                this.coupledFront = id;
                if (id != null) break;
                this.lastKnownFront = null;
                break;
            }
            case BACK: {
                this.coupledBack = id;
                if (id != null) break;
                this.lastKnownRear = null;
            }
        }
        if (this.getCoupled(coupler) != null) {
            BiConsumer<EntityCoupleableRollingStock, Boolean> fn = new BiConsumer<EntityCoupleableRollingStock, Boolean>(){
                double speed = 0.0;
                double weight = 0.0;

                @Override
                public void accept(EntityCoupleableRollingStock e, Boolean direction) {
                    this.speed += e.getCurrentSpeed().metric() * e.getWeight() * (double)(direction != false ? 1 : -1);
                    this.weight += e.getWeight();
                }

                public int hashCode() {
                    return (int)(this.speed / this.weight);
                }
            };
            this.mapTrain(this, true, true, fn);
            Speed speedPos = Speed.fromMetric(fn.hashCode());
            Speed speedNeg = Speed.fromMetric(-fn.hashCode());
            this.mapTrain(this, true, true, (e, b) -> e.setCurrentSpeed(b != false ? speedPos : speedNeg));
        }
        this.triggerTrain();
    }

    public final UUID getCoupledUUID(CouplerType coupler) {
        switch (coupler) {
            case FRONT: {
                return this.coupledFront;
            }
            case BACK: {
                return this.coupledBack;
            }
        }
        return null;
    }

    public EntityCoupleableRollingStock getCoupled(CouplerType coupler) {
        if (this.getCoupledUUID(coupler) != null) {
            return this.findByUUID(this.getCoupledUUID(coupler));
        }
        return null;
    }

    public CouplerType getCouplerFor(EntityCoupleableRollingStock stock) {
        if (stock == null) {
            return null;
        }
        for (CouplerType coupler : CouplerType.values()) {
            if (!stock.getUUID().equals(this.getCoupledUUID(coupler))) continue;
            return coupler;
        }
        return null;
    }

    public boolean isCouplerEngaged(CouplerType coupler) {
        if (coupler == null) {
            return false;
        }
        switch (coupler) {
            case FRONT: {
                return this.frontCouplerEngaged;
            }
            case BACK: {
                return this.backCouplerEngaged;
            }
        }
        return false;
    }

    public void setCouplerEngaged(CouplerType coupler, boolean engaged) {
        switch (coupler) {
            case FRONT: {
                this.frontCouplerEngaged = engaged;
                break;
            }
            case BACK: {
                this.backCouplerEngaged = engaged;
            }
        }
    }

    public final boolean isCoupled() {
        return this.isCoupled(CouplerType.FRONT) && this.isCoupled(CouplerType.BACK);
    }

    public final boolean isCoupled(CouplerType coupler) {
        return this.getCoupledUUID(coupler) != null;
    }

    public final boolean isCoupled(EntityCoupleableRollingStock stock) {
        return this.getCouplerFor(stock) != null;
    }

    public void decouple() {
        this.decouple(CouplerType.FRONT);
        this.decouple(CouplerType.BACK);
    }

    public void decouple(EntityCoupleableRollingStock stock) {
        if (stock.getUUID().equals(this.getCoupledUUID(CouplerType.FRONT))) {
            this.decouple(CouplerType.FRONT);
        } else if (stock.getUUID().equals(this.getCoupledUUID(CouplerType.BACK))) {
            this.decouple(CouplerType.BACK);
        }
    }

    public void decouple(CouplerType coupler) {
        EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
        ImmersiveRailroading.info((String)(this.getUUID() + " decouple " + (Object)((Object)coupler)), (Object[])new Object[0]);
        this.setCoupledUUID(coupler, null);
        if (coupled != null) {
            coupled.decouple(this);
        }
    }

    private Vec3d getCouplerPositionTo(CouplerType coupler, TickPos myPos, TickPos coupledPos) {
        return myPos.position.add(coupledPos.position.subtract(myPos.position).normalize().scale(this.getDefinition().getCouplerPosition(coupler, this.gauge)));
    }

    @Override
    protected void clearPositionCache() {
        super.clearPositionCache();
        this.couplerFrontPosition = null;
        this.couplerRearPosition = null;
    }

    public Vec3d getCouplerPosition(CouplerType coupler) {
        return this.getCouplerPosition(coupler, this.getCurrentTickPosOrFake());
    }

    public Vec3d getCouplerPosition(CouplerType coupler, TickPos pos) {
        if (coupler == CouplerType.FRONT) {
            if (this.couplerFrontPosition == null) {
                this.couplerFrontPosition = this.predictRearBogeyPosition(pos, (float)(-(this.getDefinition().getCouplerPosition(coupler, this.gauge) + (double)this.getDefinition().getBogeyRear(this.gauge)))).add(pos.position).add(0.0, 1.0, 0.0);
            }
            return this.couplerFrontPosition;
        }
        if (this.couplerRearPosition == null) {
            this.couplerRearPosition = this.predictFrontBogeyPosition(pos, (float)(this.getDefinition().getCouplerPosition(coupler, this.gauge) - (double)this.getDefinition().getBogeyFront(this.gauge))).add(pos.position).add(0.0, 1.0, 0.0);
        }
        return this.couplerRearPosition;
    }

    public Pair<EntityCoupleableRollingStock, CouplerType> potentialCouplings(CouplerType coupler) {
        List<EntityCoupleableRollingStock> train = this.getTrain();
        List nearBy = this.getWorld().getEntities(entity -> {
            if (entity == null) {
                return false;
            }
            if (entity.isDead()) {
                return false;
            }
            if (entity.getPosition().distanceTo(this.getPosition()) > 64.0) {
                return false;
            }
            if (entity.gauge != this.gauge) {
                return false;
            }
            for (EntityCoupleableRollingStock stock : train) {
                if (!stock.getUUID().equals(entity.getUUID())) continue;
                return false;
            }
            return true;
        }, EntityCoupleableRollingStock.class);
        Pair bestMatch = null;
        double bestDistance = 100.0;
        Vec3d myCouplerPos = this.getCouplerPosition(coupler);
        Vec3d myOppositeCouplerPos = this.getCouplerPosition(coupler.opposite());
        for (EntityCoupleableRollingStock stock : nearBy) {
            RealBB myBB;
            double couplerDistRear;
            Vec3d stockFrontPos = stock.getCouplerPosition(CouplerType.FRONT);
            Vec3d stockBackPos = stock.getCouplerPosition(CouplerType.BACK);
            double couplerDistFront = this.getPosition().distanceTo(stockFrontPos);
            CouplerType otherCoupler = couplerDistFront < (couplerDistRear = this.getPosition().distanceTo(stockBackPos)) ? CouplerType.FRONT : CouplerType.BACK;
            if (stock.isCoupled(otherCoupler)) continue;
            Vec3d stockCouplerPos = otherCoupler == CouplerType.FRONT ? stockFrontPos : stockBackPos;
            double myCouplerToOtherCoupler = myCouplerPos.distanceTo(stockCouplerPos);
            double myCenterToMyCoupler = this.getPosition().distanceTo(myCouplerPos);
            double myCenterToOtherCoupler = this.getPosition().distanceTo(stockCouplerPos);
            double myCouplerToOtherCenter = myCouplerPos.distanceTo(stock.getPosition());
            double myOppositeCouplerToOtherCenter = myOppositeCouplerPos.distanceTo(stock.getPosition());
            if (myCouplerToOtherCoupler > bestDistance || (!(myCenterToMyCoupler < myCenterToOtherCoupler) || !this.isCouplerEngaged(coupler) || !stock.isCouplerEngaged(otherCoupler) ? !(myBB = this.getCollision().contract(new Vec3d(0.0, 0.0, 0.25))).contains(stockCouplerPos) : myCouplerToOtherCoupler > Config.ConfigDebug.couplerRange)) continue;
            if (myCouplerToOtherCenter > myOppositeCouplerToOtherCenter || (stock = this.findByUUID(stock.getUUID())) == null) continue;
            bestMatch = Pair.of((Object)((Object)stock), (Object)((Object)otherCoupler));
            bestDistance = myCouplerToOtherCoupler;
        }
        return bestMatch;
    }

    public void triggerTrain() {
        for (EntityCoupleableRollingStock stock : this.getTrain()) {
            stock.triggerResimulate();
        }
    }

    public final List<EntityCoupleableRollingStock> getTrain() {
        return this.getTrain(true);
    }

    public final List<EntityCoupleableRollingStock> getTrain(boolean followDisengaged) {
        ArrayList<EntityCoupleableRollingStock> train = new ArrayList<EntityCoupleableRollingStock>();
        this.mapTrain(this, followDisengaged, train::add);
        return train;
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean followDisengaged, Consumer<EntityCoupleableRollingStock> fn) {
        this.mapTrain(prev, true, followDisengaged, (e, b) -> fn.accept((EntityCoupleableRollingStock)((Object)e)));
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean direction, boolean followDisengaged, BiConsumer<EntityCoupleableRollingStock, Boolean> fn) {
        for (DirectionalStock stock : this.getDirectionalTrain(followDisengaged)) {
            fn.accept(stock.stock, stock.direction);
        }
    }

    public Collection<DirectionalStock> getDirectionalTrain(boolean followDisengaged) {
        HashSet<UUID> trainMap = new HashSet<UUID>();
        ArrayList<DirectionalStock> trainList = new ArrayList<DirectionalStock>();
        Function<DirectionalStock, DirectionalStock> next = current -> {
            for (CouplerType coupler : CouplerType.values()) {
                EntityCoupleableRollingStock coupled;
                EntityCoupleableRollingStock stock = current.stock;
                boolean direction = current.direction;
                if (stock.getCoupledUUID(coupler) == null || trainMap.contains(stock.getCoupledUUID(coupler)) || !followDisengaged && !stock.isCouplerEngaged(coupler) || (coupled = stock.getCoupled(coupler)) == null) continue;
                CouplerType otherCoupler = coupled.getCouplerFor(stock);
                if (!followDisengaged && !coupled.isCouplerEngaged(otherCoupler)) continue;
                return new DirectionalStock(stock, coupled, coupler.opposite() == otherCoupler ? direction : !direction);
            }
            return null;
        };
        DirectionalStock start = new DirectionalStock(null, this, true);
        trainMap.add(start.stock.getUUID());
        trainList.add(start);
        for (int i = 0; i < 2; ++i) {
            DirectionalStock current2 = next.apply(start);
            while (current2 != null) {
                trainMap.add(current2.stock.getUUID());
                trainList.add(current2);
                current2 = next.apply(current2);
            }
        }
        return trainList;
    }

    public EntityCoupleableRollingStock findByUUID(UUID uuid) {
        return (EntityCoupleableRollingStock)this.getWorld().getEntity(uuid, EntityCoupleableRollingStock.class);
    }

    @Override
    public void triggerResimulate() {
        if (this.resimulateCooldown <= 0) {
            this.resimulate = true;
            this.resimulateCooldown = 5;
        }
    }

    static {
        World.onTick(world -> {
            if (world.isClient) {
                return;
            }
            List entities = world.getEntities(EntityCoupleableRollingStock.class);
            for (EntityCoupleableRollingStock stock : entities) {
                if (stock.getCurrentSpeed().minecraft() == 0.0 && !Config.ConfigDebug.keepStockLoaded) continue;
                world.keepLoaded(stock.getBlockPosition());
            }
            for (EntityCoupleableRollingStock stock : entities) {
                if (!(stock instanceof Locomotive)) continue;
                stock.tickPosRemainingCheck();
            }
            for (EntityCoupleableRollingStock stock : entities) {
                stock.tickPosRemainingCheck();
            }
            try {
                Thread.sleep(Config.ConfigDebug.lagServer);
            }
            catch (InterruptedException e) {
                ImmersiveRailroading.catching((Throwable)e);
            }
        });
    }

    public static class DirectionalStock {
        public final EntityCoupleableRollingStock prev;
        public final EntityCoupleableRollingStock stock;
        public final boolean direction;

        public DirectionalStock(EntityCoupleableRollingStock prev, EntityCoupleableRollingStock stock, boolean direction) {
            this.prev = prev;
            this.stock = stock;
            this.direction = direction;
        }
    }

    public static enum CouplerType {
        FRONT(0.0f),
        BACK(180.0f);

        public final float yaw;

        private CouplerType(float yaw) {
            this.yaw = yaw;
        }

        public CouplerType opposite() {
            return this == FRONT ? BACK : FRONT;
        }

        public String toString() {
            return (this == FRONT ? ChatText.COUPLER_FRONT : ChatText.COUPLER_BACK).toString();
        }
    }
}

