/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.physics.MovementSimulator;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RealBB;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.entity.custom.ICollision;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.sound.ISound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class EntityMoveableRollingStock
extends EntityRidableRollingStock
implements ICollision {
    public static final String DAMAGE_SOURCE_HIT = "immersiverailroading:hitByTrain";
    @TagField(value="frontYaw")
    private Float frontYaw;
    @TagField(value="rearYaw")
    private Float rearYaw;
    @TagField(value="distanceTraveled")
    public float distanceTraveled = 0.0f;
    @TagField(value="tickPosID")
    public double tickPosID = 0.0;
    private Speed currentSpeed;
    @TagField(value="positions", mapper=TickPos.ListTagMapper.class)
    public List<TickPos> positions = new ArrayList<TickPos>();
    private RealBB boundingBox;
    private float[][] heightMapCache;
    @TagField(value="tickSkew")
    private double tickSkew = 1.0;
    private float sndRand;
    private ISound wheel_sound;
    private ISound clackFront;
    private ISound clackRear;
    private Vec3i clackFrontPos;
    private Vec3i clackRearPos;
    private Vec3i lastRetarderPos = null;
    private int lastRetarderValue = 0;

    @Override
    public void load(TagCompound data) {
        super.load(data);
        if (this.positions.isEmpty()) {
            this.tickPosID = 0.0;
            this.positions.add(this.getCurrentTickPosOrFake());
        }
        if (this.frontYaw == null) {
            this.frontYaw = Float.valueOf(this.getRotationYaw());
        }
        if (this.rearYaw == null) {
            this.rearYaw = Float.valueOf(this.getRotationYaw());
        }
    }

    public void initPositions(TickPos tp) {
        this.positions = Arrays.asList(tp);
    }

    public void clearHeightMap() {
        this.heightMapCache = null;
        this.boundingBox = null;
    }

    private float[][] getHeightMap() {
        if (this.heightMapCache == null) {
            this.heightMapCache = this.getDefinition().createHeightMap(this);
        }
        return this.heightMapCache;
    }

    public RealBB getCollision() {
        if (this.boundingBox == null) {
            this.boundingBox = this.getDefinition().getBounds(this, this.gauge).withHeightMap(this.getHeightMap()).contract(new Vec3d(0.0, 0.5 * this.gauge.scale(), 0.0)).offset(new Vec3d(0.0, 0.5 * this.gauge.scale(), 0.0));
        }
        return this.boundingBox;
    }

    public Speed getCurrentSpeed() {
        if (this.currentSpeed == null) {
            Vec3d motion = this.getVelocity();
            float speed = (float)Math.sqrt(motion.x * motion.x + motion.y * motion.y + motion.z * motion.z);
            if (Float.isNaN(speed)) {
                speed = 0.0f;
            }
            this.currentSpeed = Speed.fromMinecraft(speed);
        }
        return this.currentSpeed;
    }

    public void setCurrentSpeed(Speed newSpeed) {
        this.currentSpeed = newSpeed;
    }

    public void handleTickPosPacket(List<TickPos> newPositions, double serverTPS) {
        this.tickSkew = serverTPS / 20.0;
        if (newPositions.size() != 0) {
            this.clearPositionCache();
            double delta = (double)newPositions.get((int)0).tickID - this.tickPosID;
            if (Math.abs(delta) > 10.0) {
                this.tickPosID = newPositions.get((int)0).tickID;
            } else {
                this.tickSkew += Math.max(-5.0, Math.min(5.0, delta)) / 100.0;
            }
        }
        this.positions = newPositions;
    }

    public TickPos getTickPos(int tickID) {
        if (this.positions.size() == 0) {
            return null;
        }
        for (TickPos pos : this.positions) {
            if (pos.tickID != tickID) continue;
            return pos;
        }
        return this.positions.get(this.positions.size() - 1);
    }

    public TickPos getCurrentTickPosAndPrune() {
        if (this.positions.size() == 0) {
            return null;
        }
        if (this.positions.get((int)0).tickID != (int)this.tickPosID) {
            while (this.positions.get((int)0).tickID < (int)this.tickPosID && this.positions.size() > 1) {
                this.positions.remove(0);
            }
        }
        return this.positions.get(0);
    }

    public int getRemainingPositions() {
        return this.positions.size();
    }

    private double skewScalar(double curr, double next) {
        if (this.getWorld().isClient) {
            return curr + (next - curr) * (double)this.getTickSkew();
        }
        return next;
    }

    private float skewScalar(float curr, float next) {
        if (this.getWorld().isClient) {
            return curr + (next - curr) * this.getTickSkew();
        }
        return next;
    }

    private float fixAngleInterp(float curr, float next) {
        if (curr - next > 180.0f) {
            curr -= 360.0f;
        }
        if (next - curr > 180.0f) {
            curr += 360.0f;
        }
        return curr;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isServer) {
            this.tickSkew = Config.ConfigDebug.serverTickCompensation ? 20.0 / this.getWorld().getTPS(1) : 1.0;
            if (this.getTickCount() % 10 == 0) {
                this.lastRetarderPos = null;
            }
        }
        if (this.getWorld().isClient) {
            this.getDefinition().getModel().onClientTick(this);
            if (ConfigSound.soundEnabled) {
                if (this.wheel_sound == null) {
                    this.wheel_sound = ImmersiveRailroading.newSound(this.getDefinition().wheel_sound, true, 40.0f, this.gauge);
                    this.sndRand = (float)Math.random() / 10.0f;
                }
                if (this.clackFront == null) {
                    this.clackFront = ImmersiveRailroading.newSound(this.getDefinition().clackFront, false, 30.0f, this.gauge);
                }
                if (this.clackRear == null) {
                    this.clackRear = ImmersiveRailroading.newSound(this.getDefinition().clackRear, false, 30.0f, this.gauge);
                }
                float adjust = (float)Math.abs(this.getCurrentSpeed().metric()) / 300.0f;
                float pitch = adjust + 0.7f;
                if (this.getDefinition().shouldScalePitch()) {
                    pitch = (float)((double)pitch / this.gauge.scale());
                }
                float volume = 0.01f + adjust;
                if (Math.abs(this.getCurrentSpeed().metric()) > 5.0 && MinecraftClient.getPlayer().getPosition().distanceTo(this.getPosition()) < 40.0) {
                    if (!this.wheel_sound.isPlaying()) {
                        this.wheel_sound.play(this.getPosition());
                    }
                    this.wheel_sound.setPitch(pitch + this.sndRand);
                    this.wheel_sound.setVolume(volume);
                    this.wheel_sound.setPosition(this.getPosition());
                    this.wheel_sound.setVelocity(this.getVelocity());
                    this.wheel_sound.update();
                } else if (this.wheel_sound.isPlaying()) {
                    this.wheel_sound.stop();
                }
                volume = Math.min(1.0f, volume * 2.0f);
                Vec3i posFront = new Vec3i(VecUtil.fromWrongYawPitch(this.getDefinition().getBogeyFront(this.gauge), this.getRotationYaw(), this.getRotationPitch()).add(this.getPosition()));
                if (BlockUtil.isIRRail(this.getWorld(), posFront)) {
                    TileRailBase rb = (TileRailBase)this.getWorld().getBlockEntity(posFront, TileRailBase.class);
                    TileRailBase tileRailBase = rb = rb != null ? rb.getParentTile() : null;
                    if (rb != null && !rb.getPos().equals((Object)this.clackFrontPos)) {
                        this.clackFront.setPitch(pitch);
                        this.clackFront.setVolume(volume);
                        this.clackFront.play(new Vec3d(posFront));
                        this.clackFrontPos = rb.getPos();
                    }
                }
                Vec3i posRear = new Vec3i(VecUtil.fromWrongYawPitch(this.getDefinition().getBogeyRear(this.gauge), this.getRotationYaw(), this.getRotationPitch()).add(this.getPosition()));
                if (BlockUtil.isIRRail(this.getWorld(), posRear)) {
                    TileRailBase rb = (TileRailBase)this.getWorld().getBlockEntity(posRear, TileRailBase.class);
                    TileRailBase tileRailBase = rb = rb != null ? rb.getParentTile() : null;
                    if (rb != null && !rb.getPos().equals((Object)this.clackRearPos)) {
                        this.clackRear.setPitch(pitch);
                        this.clackRear.setVolume(volume);
                        this.clackRear.play(new Vec3d(posRear));
                        this.clackRearPos = rb.getPos();
                    }
                }
            }
        }
        this.tickPosID += (double)this.getTickSkew();
        TickPos currentPos = this.getCurrentTickPosAndPrune();
        if (currentPos == null) {
            return;
        }
        Vec3d prevPos = this.getPosition();
        double prevPosX = prevPos.x;
        double prevPosY = prevPos.y;
        double prevPosZ = prevPos.z;
        float prevRotationYaw = this.getRotationYaw();
        float prevRotationPitch = this.getRotationPitch();
        if (this.getWorld().isClient) {
            this.frontYaw = Float.valueOf(this.fixAngleInterp(this.frontYaw == null ? prevRotationYaw : this.frontYaw.floatValue(), currentPos.frontYaw));
            this.rearYaw = Float.valueOf(this.fixAngleInterp(this.rearYaw == null ? prevRotationYaw : this.rearYaw.floatValue(), currentPos.rearYaw));
            prevRotationYaw = this.fixAngleInterp(prevRotationYaw, currentPos.rotationYaw);
        }
        this.setRotationYaw(this.skewScalar(prevRotationYaw, currentPos.rotationYaw));
        this.setRotationPitch(this.skewScalar(prevRotationPitch, currentPos.rotationPitch));
        this.frontYaw = Float.valueOf(this.skewScalar(this.frontYaw == null ? prevRotationYaw : this.frontYaw.floatValue(), currentPos.frontYaw));
        this.rearYaw = Float.valueOf(this.skewScalar(this.rearYaw == null ? prevRotationYaw : this.rearYaw.floatValue(), currentPos.rearYaw));
        this.currentSpeed = currentPos.speed;
        this.distanceTraveled = this.skewScalar(this.distanceTraveled, this.distanceTraveled + (float)this.currentSpeed.minecraft());
        this.setPosition(new Vec3d(this.skewScalar(prevPosX, currentPos.position.x), this.skewScalar(prevPosY, currentPos.position.y), this.skewScalar(prevPosZ, currentPos.position.z)));
        this.setVelocity(this.getPosition().subtract(prevPosX, prevPosY, prevPosZ));
        if (this.getVelocity().length() > 0.001) {
            this.clearPositionCache();
        }
        if (this.getCurrentSpeed().metric() > 1.0) {
            List entitiesWithin = this.getWorld().getEntities(entity -> entity.isLiving() || entity.isPlayer() && this.getCollision().intersects(entity.getBounds()), Entity.class);
            for (Entity entity2 : entitiesWithin) {
                if (entity2 instanceof EntityMoveableRollingStock || entity2.getRiding() instanceof EntityMoveableRollingStock || entity2.isPlayer() && entity2.getTickCount() < 100 || !this.getCollision().intersects(entity2.getBounds())) continue;
                entity2.setVelocity(this.getVelocity().scale(2.0));
                double speedDamage = this.getCurrentSpeed().metric() / Config.ConfigDamage.entitySpeedDamage;
                if (!(speedDamage > 1.0)) continue;
                entity2.directDamage(DAMAGE_SOURCE_HIT, speedDamage);
            }
            RealBB bb = this.getCollision().offset(new Vec3d(0.0, this.gauge.scale() * 2.0, 0.0));
            List entitiesAbove = this.getWorld().getEntities(entity -> entity.isLiving() || entity.isPlayer() && bb.intersects(entity.getBounds()), Entity.class);
            for (Entity entity3 : entitiesAbove) {
                if (entity3 instanceof EntityMoveableRollingStock || entity3.getRiding() instanceof EntityMoveableRollingStock || !bb.intersects(entity3.getBounds())) continue;
                entity3.setVelocity(this.getVelocity().add(0.0, entity3.getVelocity().y, 0.0));
            }
        }
        if (this.getWorld().isServer && this.getTickCount() % 5 == 0 && Math.abs(this.getCurrentSpeed().metric()) > 0.5) {
            RealBB bb = this.getCollision().grow(new Vec3d(-0.25 * this.gauge.scale(), 0.0, -0.25 * this.gauge.scale()));
            for (Vec3i bp : this.getWorld().blocksInBounds((IBoundingBox)bb)) {
                if (!BlockUtil.isIRRail(this.getWorld(), bp)) {
                    if (!Config.ConfigDamage.TrainsBreakBlocks || !this.getWorld().canEntityCollideWith(bp, DAMAGE_SOURCE_HIT) || BlockUtil.isIRRail(this.getWorld(), bp.up())) continue;
                    this.getWorld().breakBlock(bp, Config.ConfigDamage.dropSnowBalls || !this.getWorld().isSnow(bp));
                    continue;
                }
                TileRailBase te = (TileRailBase)this.getWorld().getBlockEntity(bp, TileRailBase.class);
                if (te == null) continue;
                te.cleanSnow();
            }
        }
    }

    protected void clearPositionCache() {
        this.boundingBox = null;
    }

    public TickPos moveRollingStock(double moveDistance, int lastTickID) {
        TickPos lastPos = this.getTickPos(lastTickID);
        if (moveDistance > 23.0) {
            ImmersiveRailroading.warn((String)"Trying to move %s at over 1000 mph, cam72cam's physics really sucks", (Object[])new Object[]{this.getUUID()});
        }
        return new MovementSimulator(this.getWorld(), lastPos, this.getDefinition().getBogeyFront(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value()).nextPosition(moveDistance);
    }

    public float getFrontYaw() {
        if (this.frontYaw != null) {
            return this.frontYaw.floatValue();
        }
        return this.getRotationYaw();
    }

    public float getRearYaw() {
        if (this.rearYaw != null) {
            return this.rearYaw.floatValue();
        }
        return this.getRotationYaw();
    }

    public TickPos getCurrentTickPosOrFake() {
        return new TickPos(0, Speed.fromMetric(0.0), this.getPosition(), this.getFrontYaw(), this.getRearYaw(), this.getRotationYaw(), this.getRotationPitch(), false);
    }

    public Vec3d predictFrontBogeyPosition(float offset) {
        return this.predictFrontBogeyPosition(this.getCurrentTickPosOrFake(), offset);
    }

    public Vec3d predictFrontBogeyPosition(TickPos pos, float offset) {
        MovementSimulator sim = new MovementSimulator(this.getWorld(), pos, this.getDefinition().getBogeyFront(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value());
        Vec3d nextFront = sim.nextPosition(sim.frontBogeyPosition(), pos.rotationYaw, pos.frontYaw, offset);
        return new PosRot(pos.position.subtract(nextFront), VecUtil.toYaw(pos.position.subtract(nextFront)));
    }

    public Vec3d predictRearBogeyPosition(float offset) {
        return this.predictRearBogeyPosition(this.getCurrentTickPosOrFake(), offset);
    }

    public Vec3d predictRearBogeyPosition(TickPos pos, float offset) {
        MovementSimulator sim = new MovementSimulator(this.getWorld(), pos, this.getDefinition().getBogeyRear(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value());
        Vec3d nextRear = sim.nextPosition(sim.rearBogeyPosition(), pos.rotationYaw, pos.rearYaw, offset);
        return new PosRot(pos.position.subtract(nextRear), VecUtil.toYaw(pos.position.subtract(nextRear)));
    }

    public int getSpeedRetarderSlowdown(TickPos latest) {
        if (new Vec3i(latest.position).equals((Object)this.lastRetarderPos)) {
            return this.lastRetarderValue;
        }
        int over = 0;
        int max = 0;
        for (Vec3i bp : this.getWorld().blocksInBounds((IBoundingBox)this.getCollision().offset(new Vec3d(0.0, this.gauge.scale(), 0.0)))) {
            TileRailBase te = (TileRailBase)this.getWorld().getBlockEntity(bp, TileRailBase.class);
            if (te == null || te.getAugment() != Augment.SPEED_RETARDER) continue;
            max = Math.max(max, this.getWorld().getRedstone(bp));
            ++over;
        }
        this.lastRetarderPos = new Vec3i(latest.position);
        this.lastRetarderValue = over * max;
        return this.lastRetarderValue;
    }

    public float getTickSkew() {
        return (float)this.tickSkew;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.getWorld().isClient) {
            this.getDefinition().getModel().onClientRemoved(this);
        }
        if (this.wheel_sound != null) {
            this.wheel_sound.stop();
        }
        if (this.clackFront != null) {
            this.clackFront.stop();
        }
    }

    public class PosRot
    extends Vec3d {
        private float rotation;

        public PosRot(double xIn, double yIn, double zIn, float rotation) {
            super(xIn, yIn, zIn);
            this.rotation = rotation;
        }

        public PosRot(Vec3d nextFront, float yaw) {
            this(nextFront.x, nextFront.y, nextFront.z, yaw);
        }

        public float getRotation() {
            return this.rotation;
        }
    }
}

