/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.entity.HandCar;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.resource.Identifier;
import org.lwjgl.opengl.GL11;

public class LocomotiveOverlay {
    private int screenWidth = GUIHelpers.getScreenWidth();
    private int screenHeight = GUIHelpers.getScreenHeight();
    private int currPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f));
    private int currPosY;
    private int currSpeedPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f));
    private int bgPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f)) - 5;
    private int bgPosY;
    private static final int gaugeWidth = 10;
    private static final int gaugeHeight = 50;
    private static final int gaugeSpacer = 10;
    private static final int scalarWidth = 10;
    private static final int scalarHeight = 50;
    private static final int scalarSpacer = 10;
    public static final Identifier OVERLAY_STEAM_TEXTURE = new Identifier("immersiverailroading:gui/overlay_steam.png");
    public static final Identifier OVERLAY_DIESEL_TEXTURE = new Identifier("immersiverailroading:gui/overlay_diesel.png");
    public static final Identifier OVERLAY_HANDCAR_TEXTURE = new Identifier("immersiverailroading:gui/overlay_handcar.png");

    public LocomotiveOverlay() {
        this.currPosY = (int)((float)this.screenHeight * ((float)ConfigGraphics.GUIPositionVertical / 100.0f));
        this.currPosY -= 50;
        this.bgPosY = (int)((float)this.screenHeight * ((float)ConfigGraphics.GUIPositionVertical / 100.0f)) - 50 - 25;
    }

    public void drawGauge(int color, float liquidAmount, float tankCapacity, String units) {
        double scale;
        String amount = String.format("%.1f%s", Float.valueOf(liquidAmount), units);
        String capacity = String.format("%.1f%s", Float.valueOf(tankCapacity), units);
        int quantHeight = (int)(50.0f * (liquidAmount / tankCapacity));
        GUIHelpers.drawRect((int)this.currPosX, (int)(this.currPosY + 50 - quantHeight), (int)10, (int)quantHeight, (int)color);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY - 6), (double)0.0);
            scale = 0.5;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GUIHelpers.drawCenteredString((String)amount, (int)0, (int)0, (int)0xFFFFFF);
        }
        matrix = OpenGL.matrix();
        var9_9 = null;
        try {
            GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY + 50 + 2), (double)0.0);
            scale = 0.5;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GUIHelpers.drawCenteredString((String)capacity, (int)0, (int)0, (int)0xFFFFFF);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (matrix != null) {
                if (var9_9 != null) {
                    try {
                        matrix.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    matrix.close();
                }
            }
        }
        this.currPosX += 20;
    }

    public void drawScalar(String string, float val, float min, float max) {
        int quantHeight = 50 - (int)(45.0f * ((val - min) / (max - min))) - 5;
        GUIHelpers.drawRect((int)this.currPosX, (int)(this.currPosY + quantHeight), (int)10, (int)5, (int)-6710887);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY - 6), (double)0.0);
            double scale = 0.5;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GUIHelpers.drawCenteredString((String)string, (int)0, (int)0, (int)0xFFFFFF);
        }
        this.currPosX += 20;
    }

    public void drawSpeedDisplay(Locomotive loco, int offset) {
        double speed = Math.abs(loco.getCurrentSpeed().metric());
        String text = "";
        switch (ConfigGraphics.speedUnit) {
            case mph: {
                text = String.format("%.2f mph", speed * 0.621371);
                break;
            }
            case ms: {
                text = String.format("%.2f m/s", speed / 3.6);
                break;
            }
            default: {
                text = String.format("%.2f km/h", speed);
            }
        }
        GUIHelpers.drawRect((int)(this.currSpeedPosX + offset), (int)(this.currPosY - 19), (int)50, (int)9, (int)-11711155);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(this.currSpeedPosX + 25 + offset), (double)(this.currPosY - 17), (double)0.0);
            double scale = 0.75;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GUIHelpers.drawCenteredString((String)text, (int)0, (int)0, (int)0xFFFFFF);
        }
    }

    public void drawBackground(Locomotive loco) {
        if (loco instanceof LocomotiveSteam) {
            GUIHelpers.texturedRect((Identifier)OVERLAY_STEAM_TEXTURE, (int)this.bgPosX, (int)this.bgPosY, (int)105, (int)85);
        }
        if (loco instanceof LocomotiveDiesel) {
            GUIHelpers.texturedRect((Identifier)OVERLAY_DIESEL_TEXTURE, (int)this.bgPosX, (int)this.bgPosY, (int)85, (int)85);
        }
        if (loco instanceof HandCar) {
            GUIHelpers.texturedRect((Identifier)OVERLAY_HANDCAR_TEXTURE, (int)this.bgPosX, (int)this.bgPosY, (int)60, (int)85);
        }
    }

    public void addSpace(int space) {
        this.currPosX += space;
    }
}

