/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Bogey;
import cam72cam.immersiverailroading.model.part.Frame;
import cam72cam.immersiverailroading.model.part.TrackFollower;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.obj.OBJVBO;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.lwjgl.opengl.GL11;

public class StockModel<T extends EntityMoveableRollingStock>
extends OBJModel {
    private final EntityRollingStockDefinition def;
    public final List<ModelComponent> allComponents;
    private Frame frame;
    private Bogey bogeyFront;
    private Bogey bogeyRear;
    private ModelComponent shell;
    private ModelComponent remaining;
    private ExpireableList<UUID, TrackFollower> frontTrackers = null;
    private ExpireableList<UUID, TrackFollower> rearTrackers = null;

    public StockModel(EntityRollingStockDefinition def) throws Exception {
        super(def.modelLoc, def.darken, def.internal_model_scale, def.textureNames.keySet());
        this.def = def;
        ComponentProvider provider = new ComponentProvider(this);
        this.parseComponents(provider, def);
        provider.parse(ModelComponentType.IMMERSIVERAILROADING_BASE_COMPONENT);
        this.remaining = provider.parse(ModelComponentType.REMAINING);
        this.allComponents = provider.components();
    }

    protected void parseComponents(ComponentProvider provider, EntityRollingStockDefinition def) {
        this.frame = new Frame(provider, def.defID, def.getValveGear());
        this.shell = provider.parse(ModelComponentType.SHELL);
        this.bogeyFront = Bogey.get(provider, this.unifiedBogies(), "FRONT");
        this.bogeyRear = Bogey.get(provider, this.unifiedBogies(), "REAR");
        if (this.bogeyFront != null && Math.abs((double)def.getBogeyFront(Gauge.from(1.435)) + this.bogeyFront.center().x) > 0.5) {
            this.frontTrackers = new ExpireableList();
        }
        if (this.bogeyRear != null && Math.abs((double)def.getBogeyRear(Gauge.from(1.435)) + this.bogeyRear.center().x) > 0.5) {
            this.rearTrackers = new ExpireableList();
        }
    }

    protected boolean unifiedBogies() {
        return true;
    }

    public final void onClientTick(EntityMoveableRollingStock stock) {
        this.effects(stock);
    }

    protected void effects(T stock) {
    }

    public final void onClientRemoved(EntityMoveableRollingStock stock) {
        this.removed(stock);
    }

    protected void removed(T stock) {
    }

    public final void render(EntityMoveableRollingStock stock, float partialTicks) {
        OBJRender render = StockRenderCache.getRender(this.def.defID);
        List<ModelComponentType> available = stock.isBuilt() ? null : stock.getItemComponents().stream().flatMap(x -> x.render.stream()).collect(Collectors.toList());
        try (OBJVBO.BoundOBJVBO bound = render.bind();
             OpenGL.With tex = render.bindTexture(stock.getTexture());
             OpenGL.With light = OpenGL.bool((int)2896, (boolean)true);
             OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);
             OpenGL.With normals = OpenGL.bool((int)2977, (boolean)true);){
            double distanceTraveled = (double)stock.distanceTraveled + stock.getCurrentSpeed().minecraft() * (double)stock.getTickSkew() * (double)partialTicks * 1.1;
            distanceTraveled /= stock.gauge.scale();
            try (ComponentRenderer draw = new ComponentRenderer(bound, available);){
                GL11.glScaled((double)stock.gauge.scale(), (double)stock.gauge.scale(), (double)stock.gauge.scale());
                this.render(stock, draw, distanceTraveled);
            }
        }
    }

    protected void render(T stock, ComponentRenderer draw, double distanceTraveled) {
        TrackFollower data2;
        Throwable throwable;
        ComponentRenderer matrix;
        this.frame.render(distanceTraveled, draw);
        draw.render(this.shell);
        if (this.bogeyFront != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.frontTrackers != null) {
                    data2 = this.frontTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.bogeyFront.center());
                        this.frontTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply((EntityMoveableRollingStock)((Object)stock));
                } else {
                    GL11.glTranslated((double)(-this.def.getBogeyFront(((EntityMoveableRollingStock)((Object)stock)).gauge)), (double)0.0, (double)0.0);
                    GL11.glRotated((double)(stock.getRotationYaw() - ((EntityMoveableRollingStock)((Object)stock)).getFrontYaw()), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)this.def.getBogeyFront(((EntityMoveableRollingStock)((Object)stock)).gauge), (double)0.0, (double)0.0);
                }
                this.bogeyFront.render(distanceTraveled, matrix);
            }
            catch (Throwable data2) {
                throwable = data2;
                throw data2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable data2) {
                            throwable.addSuppressed(data2);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
        if (this.bogeyRear != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.rearTrackers != null) {
                    data2 = this.rearTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.bogeyRear.center());
                        this.rearTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply((EntityMoveableRollingStock)((Object)stock));
                } else {
                    GL11.glTranslated((double)(-this.def.getBogeyRear(((EntityMoveableRollingStock)((Object)stock)).gauge)), (double)0.0, (double)0.0);
                    GL11.glRotated((double)(stock.getRotationYaw() - ((EntityMoveableRollingStock)((Object)stock)).getRearYaw()), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)this.def.getBogeyRear(((EntityMoveableRollingStock)((Object)stock)).gauge), (double)0.0, (double)0.0);
                }
                this.bogeyRear.render(distanceTraveled, matrix);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
        draw.render(this.remaining);
    }
}

