/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.components;

import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.model.obj.OBJModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ComponentProvider {
    private final OBJModel model;
    private final Set<String> groups;
    private final List<ModelComponent> components;

    public ComponentProvider(OBJModel model) {
        this.model = model;
        this.groups = new HashSet<String>(model.groups());
        this.components = new ArrayList<ModelComponent>();
    }

    private Set<String> modelIDs(String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Set<String> modelIDs = this.groups.stream().filter(group -> regex.matcher((CharSequence)group).matches()).collect(Collectors.toSet());
        this.groups.removeAll(modelIDs);
        return modelIDs;
    }

    public ModelComponent parse(ModelComponentType type) {
        Set<String> ids = this.modelIDs(type.regex);
        if (!ids.isEmpty()) {
            ModelComponent component = new ModelComponent(type, null, null, this.model, ids);
            this.components.add(component);
            return component;
        }
        return null;
    }

    public List<ModelComponent> parse(ModelComponentType ... types) {
        return Arrays.stream(types).map(this::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ModelComponent parse(ModelComponentType type, String pos) {
        Set<String> ids = this.modelIDs(type.regex.replace("#POS#", pos).replace("#SIDE#", pos));
        if (!ids.isEmpty()) {
            ModelComponent component = new ModelComponent(type, pos, null, this.model, ids);
            this.components.add(component);
            return component;
        }
        return null;
    }

    public List<ModelComponent> parse(String pos, ModelComponentType ... types) {
        return Arrays.stream(types).map(type -> this.parse((ModelComponentType)((Object)type), pos)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ModelComponent> parseAll(ModelComponentType type) {
        ArrayList<ModelComponent> components = new ArrayList<ModelComponent>();
        for (int i = 100; i >= 0; --i) {
            Set<String> ids = this.modelIDs(type.regex.replace("#ID#", i + ""));
            if (ids.isEmpty()) continue;
            ModelComponent component = new ModelComponent(type, null, i, this.model, ids);
            this.components.add(component);
            components.add(component);
        }
        return components;
    }

    public List<ModelComponent> parseAll(ModelComponentType ... types) {
        return Arrays.stream(types).flatMap(type -> this.parseAll((ModelComponentType)((Object)type)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ModelComponent> parseAll(ModelComponentType type, String pos) {
        ArrayList<ModelComponent> components = new ArrayList<ModelComponent>();
        for (int i = 100; i >= 0; --i) {
            Set<String> ids = this.modelIDs(type.regex.replace("#ID#", i + "").replace("#POS#", pos).replace("#SIDE#", pos));
            if (ids.isEmpty()) continue;
            ModelComponent component = new ModelComponent(type, pos, i, this.model, ids);
            this.components.add(component);
            components.add(component);
        }
        return components;
    }

    public List<ModelComponent> components() {
        return this.components;
    }
}

