/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.StephensonValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class WalschaertsValveGear
extends StephensonValveGear {
    protected final ModelComponent crossHead;
    protected final ModelComponent combinationLever;
    protected final ModelComponent returnCrank;
    protected final ModelComponent returnCrankRod;
    protected final ModelComponent slottedLink;
    protected final ModelComponent radiusBar;
    protected final List<ModelComponent> todo;
    private final Vec3d crankWheel;

    public static WalschaertsValveGear get(WheelSet wheels, ComponentProvider provider, String pos, float angleOffset) {
        ModelComponent drivingRod = provider.parse(ModelComponentType.MAIN_ROD_SIDE, pos);
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        ModelComponent pistonRod = provider.parse(ModelComponentType.PISTON_ROD_SIDE, pos);
        ModelComponent cylinder = provider.parse(ModelComponentType.CYLINDER_SIDE, pos);
        ModelComponent crossHead = provider.parse(ModelComponentType.UNION_LINK_SIDE, pos);
        ModelComponent combinationLever = provider.parse(ModelComponentType.COMBINATION_LEVER_SIDE, pos);
        ModelComponent returnCrank = provider.parse(ModelComponentType.ECCENTRIC_CRANK_SIDE, pos);
        ModelComponent returnCrankRod = provider.parse(ModelComponentType.ECCENTRIC_ROD_SIDE, pos);
        ModelComponent slottedLink = provider.parse(ModelComponentType.EXPANSION_LINK_SIDE, pos);
        ModelComponent radiusBar = provider.parse(ModelComponentType.RADIUS_BAR_SIDE, pos);
        List<ModelComponent> todo = provider.parse(pos, ModelComponentType.VALVE_STEM_SIDE, ModelComponentType.REVERSING_ARM_SIDE, ModelComponentType.LIFTING_LINK_SIDE, ModelComponentType.REACH_ROD_SIDE);
        return drivingRod != null && connectingRod != null && pistonRod != null && crossHead != null && combinationLever != null && returnCrank != null && returnCrankRod != null && slottedLink != null && radiusBar != null ? new WalschaertsValveGear(wheels, drivingRod, connectingRod, pistonRod, cylinder, angleOffset, crossHead, combinationLever, returnCrank, returnCrankRod, slottedLink, radiusBar, todo) : null;
    }

    public WalschaertsValveGear(WheelSet wheels, ModelComponent drivingRod, ModelComponent connectingRod, ModelComponent pistonRod, ModelComponent cylinder, float angleOffset, ModelComponent crossHead, ModelComponent combinationLever, ModelComponent returnCrank, ModelComponent returnCrankRod, ModelComponent slottedLink, ModelComponent radiusBar, List<ModelComponent> todo) {
        super(wheels, drivingRod, connectingRod, pistonRod, cylinder, angleOffset);
        this.crossHead = crossHead;
        this.combinationLever = combinationLever;
        this.returnCrank = returnCrank;
        this.returnCrankRod = returnCrankRod;
        this.slottedLink = slottedLink;
        this.radiusBar = radiusBar;
        this.todo = todo;
        this.crankWheel = wheels.wheels.stream().map(w -> w.wheel.center).min(Comparator.comparingDouble(w -> w.distanceTo(this.reverse ? returnCrank.min : returnCrank.max))).get();
    }

    @Override
    public void render(double distance, float throttle, ComponentRenderer draw) {
        super.render(distance, throttle, draw);
        float wheelAngle = super.angle(distance);
        Vec3d connRodPos = this.connectingRod.center;
        double connRodRadius = connRodPos.x - this.centerOfWheels.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, wheelAngle);
        double pistonDelta = connRodMovment.x - connRodRadius;
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            matrix.render(this.crossHead);
        }
        Vec3d returnCrankRotPoint = this.reverse ? this.returnCrank.min.add(this.returnCrank.height() / 2.0, this.returnCrank.height() / 2.0, 0.0) : this.returnCrank.max.add(-this.returnCrank.height() / 2.0, -this.returnCrank.height() / 2.0, 0.0);
        Vec3d wheelRotationOffset = this.reverse ? VecUtil.fromWrongYaw(returnCrankRotPoint.x - this.crankWheel.x, wheelAngle) : VecUtil.fromWrongYaw(returnCrankRotPoint.x - this.crankWheel.x, wheelAngle);
        Vec3d returnCrankOriginOffset = this.crankWheel.add(wheelRotationOffset.x, wheelRotationOffset.z, 0.0);
        double returnCrankAngle = wheelAngle + 90.0f + 30.0f;
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)returnCrankOriginOffset.x, (double)returnCrankOriginOffset.y, (double)0.0);
            GL11.glRotated((double)returnCrankAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-returnCrankRotPoint.x), (double)(-returnCrankRotPoint.y), (double)0.0);
            matrix.render(this.returnCrank);
        }
        double returnCrankLength = -(this.returnCrank.length() - this.returnCrank.height() / 2.0 - this.returnCrankRod.height() / 2.0);
        Vec3d returnCrankRotationOffset = VecUtil.fromWrongYaw(returnCrankLength, (float)returnCrankAngle + (float)(this.reverse ? 90 : -90));
        Vec3d returnCrankRodOriginOffset = returnCrankOriginOffset.add(returnCrankRotationOffset.x, returnCrankRotationOffset.z, 0.0);
        Vec3d returnCrankRodRotPoint = this.reverse ? this.returnCrankRod.min.add(this.returnCrankRod.height() / 2.0, this.returnCrankRod.height() / 2.0, 0.0) : this.returnCrankRod.max.add(-this.returnCrankRod.height() / 2.0, -this.returnCrankRod.height() / 2.0, 0.0);
        double returnCrankRodLength = this.returnCrankRod.length() - this.returnCrankRod.height() / 2.0;
        double slottedLinkLowest = this.slottedLink.min.y + this.slottedLink.width() / 2.0;
        double returnCrankRodFudge = this.reverse ? Math.abs(this.slottedLink.center.x - (returnCrankRodOriginOffset.x + returnCrankRodLength)) / 3.0 : Math.abs(this.slottedLink.center.x - (returnCrankRodOriginOffset.x - returnCrankRodLength)) / 3.0;
        float returnCrankRodRot = this.reverse ? -VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength)) : VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength));
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)returnCrankRodOriginOffset.x, (double)returnCrankRodOriginOffset.y, (double)0.0);
            GL11.glRotated((double)returnCrankRodRot, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-returnCrankRodRotPoint.x), (double)(-returnCrankRodRotPoint.y), (double)0.0);
            matrix.render(this.returnCrankRod);
        }
        Vec3d returnCrankRodRotationOffset = VecUtil.fromWrongYaw(returnCrankRodLength, returnCrankRodRot + (float)(this.reverse ? -90 : 90));
        Vec3d returnCrankRodFarPoint = returnCrankRodOriginOffset.add(returnCrankRodRotationOffset.x, returnCrankRodRotationOffset.z, 0.0);
        Vec3d slottedLinkRotPoint = this.slottedLink.center;
        double slottedLinkRot = Math.toDegrees(Math.atan2(-slottedLinkRotPoint.x + returnCrankRodFarPoint.x, slottedLinkRotPoint.y - returnCrankRodFarPoint.y));
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)slottedLinkRotPoint.x, (double)slottedLinkRotPoint.y, (double)0.0);
            GL11.glRotated((double)slottedLinkRot, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-slottedLinkRotPoint.x), (double)(-slottedLinkRotPoint.y), (double)0.0);
            matrix.render(this.slottedLink);
        }
        double forwardMax = (this.slottedLink.min.y - slottedLinkRotPoint.y) * 0.4;
        double forwardMin = (this.slottedLink.max.y - slottedLinkRotPoint.y) * 0.65;
        double throttleSlotPos = 0.0;
        throttleSlotPos = throttle > 0.0f ? forwardMax * (double)throttle : forwardMin * (double)(-throttle);
        double radiusBarSliding = Math.sin(Math.toRadians(-slottedLinkRot)) * throttleSlotPos;
        Vec3d radiusBarClose = this.reverse ? this.radiusBar.min : this.radiusBar.max;
        float raidiusBarAngle = this.reverse ? -(VecUtil.toWrongYaw(new Vec3d(this.radiusBar.length(), 0.0, throttleSlotPos)) + 90.0f) : VecUtil.toWrongYaw(new Vec3d(this.radiusBar.length(), 0.0, throttleSlotPos += slottedLinkRotPoint.y - this.radiusBar.max.y)) + 90.0f;
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)0.0, (double)throttleSlotPos, (double)0.0);
            GL11.glTranslated((double)radiusBarSliding, (double)0.0, (double)0.0);
            GL11.glTranslated((double)radiusBarClose.x, (double)radiusBarClose.y, (double)0.0);
            GL11.glRotated((double)raidiusBarAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-radiusBarClose.x), (double)(-radiusBarClose.y), (double)0.0);
            matrix.render(this.radiusBar);
        }
        Vec3d radiusBarFar = this.reverse ? this.radiusBar.max : this.radiusBar.min;
        Vec3d radiusBarFarPoint = radiusBarFar.add(radiusBarSliding + this.combinationLever.width() / 2.0, 0.0, 0.0);
        Vec3d combinationLeverRotPos = this.combinationLever.min.add(this.combinationLever.width() / 2.0, this.combinationLever.width() / 2.0, 0.0);
        Vec3d delta = radiusBarFarPoint.subtract(combinationLeverRotPos.add(pistonDelta, 0.0, 0.0));
        float combinationLeverAngle = VecUtil.toWrongYaw(new Vec3d(delta.x, 0.0, delta.y));
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            GL11.glTranslated((double)combinationLeverRotPos.x, (double)combinationLeverRotPos.y, (double)0.0);
            GL11.glRotated((double)combinationLeverAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-combinationLeverRotPos.x), (double)(-combinationLeverRotPos.y), (double)0.0);
            matrix.render(this.combinationLever);
        }
        draw.render(this.todo);
    }
}

