/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.CarFreightDefinition;
import cam72cam.immersiverailroading.registry.CarPassengerDefinition;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.HandCarDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.TenderDefinition;
import cam72cam.immersiverailroading.registry.TrackDefinition;
import cam72cam.mod.gui.Progress;
import cam72cam.mod.resource.Identifier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class DefinitionManager {
    private static final long STOCK_LOAD_MEMORY_PER_PROCESSOR = 1704984576L;
    private static Map<String, EntityRollingStockDefinition> definitions;
    private static Map<String, TrackDefinition> tracks;
    private static Map<String, JsonLoader> jsonLoaders;

    private static void initGauges() throws IOException {
        for (Gauge value : new ArrayList<Gauge>(Gauge.values())) {
            Gauge.remove(value.value());
        }
        Identifier gauges_json = new Identifier("immersiverailroading", "rolling_stock/gauges.json");
        ArrayList<Double> toRemove = new ArrayList<Double>();
        List inputs = gauges_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject gauges = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            if (gauges.has("register")) {
                for (Map.Entry gauge : gauges.get("register").getAsJsonObject().entrySet()) {
                    Gauge.register(((JsonElement)gauge.getValue()).getAsDouble(), (String)gauge.getKey());
                }
            }
            if (!gauges.has("remove")) continue;
            for (Map.Entry gauge : gauges.get("remove").getAsJsonArray()) {
                toRemove.add(gauge.getAsDouble());
            }
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            double gauge = (Double)iterator.next();
            Gauge.remove(gauge);
        }
    }

    public static void initDefinitions() {
        try {
            DefinitionManager.initGauges();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load gauges, do you have a broken pack?", e);
        }
        Runtime runtime = Runtime.getRuntime();
        int processors = runtime.availableProcessors() - 1;
        runtime.gc();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = totalMemory;
        }
        int loadingThreads = Math.max(1, Math.min(processors, (int)(maxMemory / 1704984576L)));
        ForkJoinPool stockLoadingPool = new ForkJoinPool(loadingThreads, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("ImmersiveRailroading-" + worker.getPoolIndex());
            return worker;
        }, null, false);
        try {
            ((ForkJoinTask)stockLoadingPool.submit(() -> {
                try {
                    DefinitionManager.initModels();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load rolling stock, do you have a broken pack?", e);
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            stockLoadingPool.shutdown();
        }
        try {
            DefinitionManager.initTracks();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load tracks, do you have a broken pack?", e);
        }
    }

    private static void initModels() throws IOException {
        ImmersiveRailroading.info((String)"Loading stock models.", (Object[])new Object[0]);
        Set<String> defTypes = jsonLoaders.keySet();
        List<String> blacklist = DefinitionManager.getModelBlacklist(defTypes);
        LinkedHashMap<String, String> definitionIDMap = new LinkedHashMap<String, String>();
        Identifier stock_json = new Identifier("immersiverailroading", "rolling_stock/stock.json");
        List inputs = stock_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject stock = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            for (String defType : defTypes) {
                if (!stock.has(defType)) continue;
                for (JsonElement defName : stock.get(defType).getAsJsonArray()) {
                    if (blacklist.contains(defName.getAsString())) {
                        ImmersiveRailroading.info((String)"Skipping blacklisted %s", (Object[])new Object[]{defName.getAsString()});
                        continue;
                    }
                    String defID = String.format("rolling_stock/%s/%s.json", defType, defName.getAsString());
                    if (definitionIDMap.containsKey(defID)) continue;
                    definitionIDMap.put(defID, defType);
                }
            }
        }
        Progress.Bar bar = Progress.push((String)"Loading Models", (int)definitionIDMap.size());
        Map<String, EntityRollingStockDefinition> loaded = DefinitionManager.getStockLoadingStream(definitionIDMap.entrySet()).map(tuple -> {
            String defID = (String)tuple.getKey();
            String defType = (String)tuple.getValue();
            ImmersiveRailroading.debug((String)("Loading stock " + defID), (Object[])new Object[0]);
            Identifier resource = new Identifier("immersiverailroading", defID);
            try {
                Pair pair;
                Throwable throwable;
                InputStream input;
                block26: {
                    block27: {
                        input = resource.getResourceStream();
                        throwable = null;
                        JsonParser parser = new JsonParser();
                        JsonObject jsonData = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
                        input.close();
                        EntityRollingStockDefinition stockDefinition = jsonLoaders.get(defType).apply(defID, jsonData);
                        pair = Pair.of((Object)stockDefinition.defID, (Object)stockDefinition);
                        if (input == null) break block26;
                        if (throwable == null) break block27;
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block26;
                    }
                    input.close();
                }
                return pair;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (input != null) {
                                if (throwable != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    input.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        ImmersiveRailroading.error((String)"Error loading model %s of type %s", (Object[])new Object[]{defID, defType});
                        ImmersiveRailroading.catching((Throwable)e);
                        throwable = null;
                        return throwable;
                    }
                }
            }
            finally {
                Progress.Bar bar2 = bar;
                synchronized (bar2) {
                    bar.step(defID);
                }
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        definitions = new LinkedHashMap<String, EntityRollingStockDefinition>();
        definitionIDMap.keySet().stream().filter(loaded::containsKey).forEach(x -> definitions.put((String)x, (EntityRollingStockDefinition)loaded.get(x)));
        Progress.pop((Progress.Bar)bar);
    }

    private static List<String> getModelBlacklist(Set<String> defTypes) throws IOException {
        ArrayList<String> blacklist = new ArrayList<String>();
        Identifier blacklist_json = new Identifier("immersiverailroading", "rolling_stock/blacklist.json");
        List inputs = blacklist_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject stock = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            for (String defType : defTypes) {
                if (!stock.has(defType)) continue;
                for (JsonElement defName : stock.get(defType).getAsJsonArray()) {
                    blacklist.add(defName.getAsString());
                }
            }
        }
        return blacklist;
    }

    private static void initTracks() throws IOException {
        tracks = new LinkedHashMap<String, TrackDefinition>();
        ImmersiveRailroading.info((String)"Loading tracks.", (Object[])new Object[0]);
        Identifier track_json = new Identifier("immersiverailroading", "track/track.json");
        List inputs = track_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject track = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            JsonArray types = track.getAsJsonArray("types");
            Progress.Bar bar = Progress.push((String)"Loading Tracks", (int)types.size());
            for (JsonElement def : types) {
                bar.step(def.getAsString());
                String trackID = String.format("immersiverailroading:track/%s.json", def.getAsString());
                ImmersiveRailroading.debug((String)"Loading Track %s", (Object[])new Object[]{trackID});
                JsonParser trackParser = new JsonParser();
                JsonObject trackData = trackParser.parse((Reader)new InputStreamReader(new Identifier(trackID).getResourceStream())).getAsJsonObject();
                try {
                    tracks.put(trackID, new TrackDefinition(trackID, trackData));
                }
                catch (Exception e) {
                    ImmersiveRailroading.catching((Throwable)e);
                }
            }
            Progress.pop((Progress.Bar)bar);
        }
    }

    private static <E> Stream<E> getStockLoadingStream(Collection<E> collection) {
        if (!Config.ConfigPerformance.multithreadedStockLoading) {
            return collection.stream();
        }
        return collection.parallelStream();
    }

    public static EntityRollingStockDefinition getDefinition(String defID) {
        return definitions.get(defID);
    }

    public static Collection<EntityRollingStockDefinition> getDefinitions() {
        return definitions.values();
    }

    public static Set<String> getDefinitionNames() {
        return definitions.keySet();
    }

    public static List<TrackDefinition> getTracks() {
        return new ArrayList<TrackDefinition>(tracks.values());
    }

    public static List<String> getTrackIDs() {
        return new ArrayList<String>(tracks.keySet());
    }

    public static TrackModel getTrack(String track, double value) {
        return DefinitionManager.getTrack(track).getTrackForGauge(value);
    }

    public static TrackDefinition getTrack(String track) {
        TrackDefinition def = tracks.get(track);
        if (def == null) {
            def = tracks.values().stream().findFirst().get();
        }
        return def;
    }

    static {
        jsonLoaders = new LinkedHashMap<String, JsonLoader>();
        jsonLoaders.put("locomotives", (defID, data) -> {
            String era;
            switch (era = data.get("era").getAsString()) {
                case "steam": {
                    return new LocomotiveSteamDefinition(defID, data);
                }
                case "diesel": {
                    return new LocomotiveDieselDefinition(defID, data);
                }
            }
            ImmersiveRailroading.warn((String)"Invalid era %s in %s", (Object[])new Object[]{era, defID});
            return null;
        });
        jsonLoaders.put("tender", TenderDefinition::new);
        jsonLoaders.put("passenger", CarPassengerDefinition::new);
        jsonLoaders.put("freight", CarFreightDefinition::new);
        jsonLoaders.put("tank", CarTankDefinition::new);
        jsonLoaders.put("hand_car", HandCarDefinition::new);
    }

    @FunctionalInterface
    private static interface JsonLoader {
        public EntityRollingStockDefinition apply(String var1, JsonObject var2) throws Exception;
    }
}

