/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.GLSLShader;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.Particle;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.world.World;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class SmokeParticle
extends Particle {
    private static GLSLShader shader;
    private static int dl;
    private final double rot;
    private final SmokeParticleData data;

    public SmokeParticle(SmokeParticleData data) {
        this.data = data;
        this.rot = Math.random() * 360.0;
    }

    public boolean depthTestEnabled() {
        return false;
    }

    public void render(float partialTicks) {
    }

    public static void renderAll(List<SmokeParticle> particles, float partialTicks) {
        if (shader == null) {
            shader = new GLSLShader(new Identifier("immersiverailroading", "particles/smoke_vert.c"), new Identifier("immersiverailroading", "particles/smoke_frag.c"));
            dl = GL11.glGenLists((int)1);
            GL11.glNewList((int)dl, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex3d((double)-1.0, (double)-1.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex3d((double)-1.0, (double)1.0, (double)0.0);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)-1.0, (double)0.0);
            GL11.glEnd();
            GL11.glEndList();
        }
        try (OpenGL.With sb = shader.bind();
             OpenGL.With light = OpenGL.bool((int)2896, (boolean)false);
             OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);
             OpenGL.With tex = OpenGL.bool((int)3553, (boolean)false);
             OpenGL.With blend = OpenGL.blend((int)770, (int)771);){
            for (SmokeParticle particle : particles) {
                double life = (float)particle.ticks / (float)particle.data.lifespan;
                double expansionRate = 16.0;
                double radius = particle.data.diameter * (Math.sqrt(life) * expansionRate + 1.0) * 0.5;
                float alpha = (particle.data.thickness + 0.2f) * (1.0f - (float)Math.sqrt(life));
                OpenGL.With matrix = OpenGL.matrix();
                Throwable throwable = null;
                try {
                    float darken = 0.9f - particle.data.darken * 0.9f;
                    shader.paramFloat("ALPHA", new float[]{alpha});
                    shader.paramFloat("DARKEN", new float[]{darken, darken, darken});
                    GL11.glTranslated((double)particle.renderX, (double)particle.renderY, (double)particle.renderZ);
                    particle.lookAtPlayer();
                    GL11.glScaled((double)radius, (double)radius, (double)radius);
                    GL11.glRotated((double)particle.rot, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
                    GL11.glRotated((double)(-particle.rot), (double)0.0, (double)0.0, (double)1.0);
                    double angle = (float)particle.ticks + partialTicks;
                    GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glCallList((int)dl);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (matrix == null) continue;
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    matrix.close();
                }
            }
        }
    }

    public static class SmokeParticleData
    extends Particle.ParticleData {
        private final float darken;
        private final float thickness;
        private final double diameter;

        public SmokeParticleData(World world, Vec3d pos, Vec3d motion, int lifespan, float darken, float thickness, double diameter) {
            super(world, pos, motion, lifespan);
            this.darken = darken;
            this.thickness = thickness;
            this.diameter = diameter;
        }
    }
}

