/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.io.Closeable;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ChunkData
implements Closeable {
    private static final IllegalStateException WRONG_TYPE = new IllegalStateException("Wrong type accessed!");
    private Long2ByteMap data;
    private int glListIndex = 0;
    private boolean generatedList = false;

    public ChunkData() {
        this((Long2ByteMap)new Long2ByteOpenHashMap());
    }

    public ChunkData(Long2ByteMap data) {
        this.data = data;
    }

    public Long2ByteMap data() {
        return this.data;
    }

    private void compileList(World level, ISelectionContext collisionContext) {
        byte crossType;
        this.generatedList = true;
        if (this.data().isEmpty()) {
            this.glListIndex = 0;
            return;
        }
        this.glListIndex = GL11.glGenLists((int)3);
        GL11.glNewList((int)this.glListIndex, (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.redColor);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
            if (crossType != 1) continue;
            ChunkData.renderCross(level, (BlockPos)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
        GL11.glNewList((int)(this.glListIndex + 1), (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.yellowColor);
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
            if (crossType != 0) continue;
            ChunkData.renderCross(level, (BlockPos)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
        GL11.glNewList((int)(this.glListIndex + 2), (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.secondaryColor);
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
            if (crossType != 2) continue;
            ChunkData.renderCross(level, (BlockPos)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void renderList(World level, ISelectionContext collisionContext) {
        if (!this.generatedList) {
            this.compileList(level, collisionContext);
        }
        if (this.glListIndex != 0) {
            GL11.glCallList((int)this.glListIndex);
            GL11.glCallList((int)(this.glListIndex + 1));
            GL11.glCallList((int)(this.glListIndex + 2));
        }
    }

    private static void color(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
    }

    public static void renderCross(World level, BlockPos pos, ISelectionContext collisionContext) {
        double blockOffset = 0.0;
        VoxelShape upperOutlineShape = level.func_180495_p(pos).func_215700_a((IBlockReader)level, pos, collisionContext);
        if (!upperOutlineShape.func_197766_b()) {
            blockOffset += upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        GL11.glVertex3d((double)((double)x + 0.01), (double)((double)y + blockOffset), (double)((double)z + 0.01));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0), (double)((double)y + blockOffset), (double)((double)z - 0.01 + 1.0));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0), (double)((double)y + blockOffset), (double)((double)z + 0.01));
        GL11.glVertex3d((double)((double)x + 0.01), (double)((double)y + blockOffset), (double)((double)z - 0.01 + 1.0));
    }

    @Override
    public void close() {
        if (this.glListIndex != 0) {
            GL11.glDeleteLists((int)this.glListIndex, (int)3);
        }
    }
}

