/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.features.TotalDarkness;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;

@Mod.EventBusSubscriber(modid="magnesium_extras", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Darkness {
    public static boolean enabled = false;
    private static final float[][] LUMINANCE = new float[16][16];

    @SubscribeEvent
    public static void onConfigChange(ModConfig.ModConfigEvent e) {
        Darkness.bake();
    }

    public static void bake() {
        MagnesiumExtrasConfig.darkNetherFogEffective = (Boolean)MagnesiumExtrasConfig.darkNether.get() != false ? (Double)MagnesiumExtrasConfig.darkNetherFogConfigured.get() : 1.0;
        MagnesiumExtrasConfig.darkEndFogEffective = (Boolean)MagnesiumExtrasConfig.darkEnd.get() != false ? (Double)MagnesiumExtrasConfig.darkEndFogConfigured.get() : 1.0;
    }

    public static boolean blockLightOnly() {
        return (Boolean)MagnesiumExtrasConfig.blockLightOnly.get();
    }

    public static double darkNetherFog() {
        return MagnesiumExtrasConfig.darkNetherFogEffective;
    }

    public static double darkEndFog() {
        return MagnesiumExtrasConfig.darkEndFogEffective;
    }

    public static void getDarkenedFogColor(CallbackInfoReturnable<Vector3d> ci, double factor) {
        if (factor != 1.0) {
            Vector3d result = (Vector3d)ci.getReturnValue();
            double MIN = 0.03;
            result = new Vector3d(Math.max(MIN, result.field_72450_a * factor), Math.max(MIN, result.field_72448_b * factor), Math.max(MIN, result.field_72449_c * factor));
            ci.setReturnValue((Object)result);
        }
    }

    private static boolean isDark(World world) {
        if (!((Boolean)MagnesiumExtrasConfig.trueDarknessEnabled.get()).booleanValue()) {
            return false;
        }
        RegistryKey dimType = world.func_234923_W_();
        if (dimType == World.field_234918_g_) {
            return (Boolean)MagnesiumExtrasConfig.darkOverworld.get();
        }
        if (dimType == World.field_234919_h_) {
            return (Boolean)MagnesiumExtrasConfig.darkNether.get();
        }
        if (dimType == World.field_234920_i_) {
            return (Boolean)MagnesiumExtrasConfig.darkEnd.get();
        }
        if (world.func_230315_m_().func_218272_d()) {
            return (Boolean)MagnesiumExtrasConfig.darkDefault.get();
        }
        return (Boolean)MagnesiumExtrasConfig.darkSkyless.get();
    }

    private static float skyFactor(World world) {
        if (!((Boolean)MagnesiumExtrasConfig.blockLightOnly.get()).booleanValue() && Darkness.isDark(world)) {
            if (world.func_230315_m_().func_218272_d()) {
                float angle = world.func_242415_f(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = (Boolean)MagnesiumExtrasConfig.ignoreMoonPhase.get() != false ? 0.0f : world.func_242413_ae();
                    float moonInterpolated = (float)MathHelper.func_219803_d((double)moon, (double)((Double)MagnesiumExtrasConfig.minimumMoonLevel.get()), (double)((Double)MagnesiumExtrasConfig.maximumMoonLevel.get()));
                    return MathHelper.func_219799_g((float)(oldWeight * oldWeight * oldWeight), (float)moonInterpolated, (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, Minecraft client, GameRenderer worldRenderer, float prevFlicker) {
        ClientWorld world = client.field_71441_e;
        if (world != null) {
            if (!Darkness.isDark((World)world) || client.field_71439_g.func_70644_a(Effects.field_76439_r) || client.field_71439_g.func_70644_a(Effects.field_205136_C) && client.field_71439_g.func_203719_J() > 0.0f || world.func_228332_n_() > 0) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((World)world);
            float ambient = world.func_228326_g_(1.0f);
            DimensionType dim = world.func_230315_m_();
            boolean blockAmbient = !Darkness.isDark((World)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float v;
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = Math.max((skyFactor *= dimSkyFactor) * 0.05f, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = dim.func_236021_a_(skyIndex) * minAmbient;
                min = Math.max(0.35f * skyFactor, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                float skyRed = v = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = v;
                float skyBlue = skyBase;
                if (worldRenderer.func_205002_d(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.func_205002_d(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * dim.func_236021_a_(blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.func_234923_W_() == World.field_234920_i_) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = (float)client.field_71474_y.field_74333_Y * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = Math.max(0.03f * f, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }
}

