/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.SodiumConfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;
import vice.magnesium_extras.mixins.BorderlessFullscreen.MainWindowAccessor;

@Mixin(value={SodiumGameOptionPages.class})
public class SodiumGameOptionsMixin {
    @Shadow
    @Final
    private static SodiumOptionsStorage sodiumOpts;
    @Shadow
    @Final
    private static MinecraftOptionsStorage vanillaOpts;

    @Inject(method={"experimental"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true)
    private static void Inject(CallbackInfoReturnable<OptionPage> cir, List<OptionGroup> groups) {
        groups.removeIf(optionGroup -> optionGroup.getOptions().stream().anyMatch(option -> Objects.equals(option.getName(), "Display FPS")));
        OptionImpl displayFps = OptionImpl.createBuilder(MagnesiumExtrasConfig.Complexity.class, (OptionStorage)sodiumOpts).setName("Display FPS").setTooltip("Displays the current FPS. Advanced mode also displays minimum FPS, as well as 15 second average FPS, which are more useful for judging performance.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.Complexity.class, new String[]{"Off", "Simple", "Advanced"})).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterMode.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.Complexity.valueOf((String)MagnesiumExtrasConfig.fpsCounterMode.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl displayFpsPos = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("FPS Display Position").setTooltip("Offsets the FPS display a few pixels").setControl(option -> new SliderControl((Option)option, 4, 64, 2, ControlValueFormatter.quantity((String)"Pixels"))).setImpact(OptionImpact.LOW).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterPosition.set(value), opts -> (Integer)MagnesiumExtrasConfig.fpsCounterPosition.get()).build();
        groups.add(OptionGroup.createBuilder().add((Option)displayFps).add((Option)displayFpsPos).build());
        OptionImpl totalDarkness = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("True Darkness").setTooltip("Makes the rest of the world more realistically dark. Does not effect daytime or torch light.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.trueDarknessEnabled.set(value), options -> (Boolean)MagnesiumExtrasConfig.trueDarknessEnabled.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl totalDarknessSetting = OptionImpl.createBuilder(MagnesiumExtrasConfig.DarknessOption.class, (OptionStorage)sodiumOpts).setName("True Darkness Mode").setTooltip("Controls how dark is considered true darkness.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.DarknessOption.class, new String[]{"Pitch Black", "Really Dark", "Dark", "Dim"})).setBinding((opts, value) -> MagnesiumExtrasConfig.darknessOption.set((Object)value), opts -> (MagnesiumExtrasConfig.DarknessOption)((Object)((Object)MagnesiumExtrasConfig.darknessOption.get()))).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)totalDarkness).add((Option)totalDarknessSetting).build());
        OptionImpl fadeInQuality = OptionImpl.createBuilder(MagnesiumExtrasConfig.Quality.class, (OptionStorage)sodiumOpts).setName("Chunk Fade In Quality").setTooltip("Controls how fast chunks fade in. No performance hit, Fancy simply takes longer, but looks a bit cooler.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.Quality.class, new String[]{"Off", "Fast", "Fancy"})).setBinding((opts, value) -> MagnesiumExtrasConfig.fadeInQuality.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.Quality.valueOf((String)MagnesiumExtrasConfig.fadeInQuality.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl fog = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Enable fog").setTooltip("Toggles off all fog in the overworld.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.fog.set(value), options -> (Boolean)MagnesiumExtrasConfig.fog.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl cloudHeight = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Cloud Height").setTooltip("Raises cloud height.").setControl(option -> new SliderControl((Option)option, 64, 256, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.cloudHeight.set(value), options -> (Integer)MagnesiumExtrasConfig.cloudHeight.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)fadeInQuality).add((Option)fog).add((Option)cloudHeight).build());
        OptionImpl enableDistanceChecks = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Enable Max Entity Distance").setTooltip("Toggles off entity culling.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.enableDistanceChecks.set(value), options -> (Boolean)MagnesiumExtrasConfig.enableDistanceChecks.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)enableDistanceChecks).build());
        OptionImpl maxEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Max Entity Distance").setTooltip("Hides and does not tick entities beyond this many blocks. Huge performance increase, especially around modded farms.").setControl(option -> new SliderControl((Option)option, 16, 192, 8, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.EXTREME).build();
        OptionImpl maxEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Vertical Entity Distance").setTooltip("Hides and does not tick entities underneath this many blocks, improving performance above caves. This should ideally be set lower than the horizontal distance.").setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceY.get()).setImpact(OptionImpact.EXTREME).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxEntityDistance).add((Option)maxEntityDistanceVertical).build());
        OptionImpl maxTileEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Max Tile Distance").setTooltip("Hides block entities beyond this many blocks. Huge performance increase, especially around lots of modded machines.").setControl(option -> new SliderControl((Option)option, 16, 256, 8, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.HIGH).build();
        OptionImpl maxTileEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Vertical Tile Distance").setTooltip("Hides block entities underneath this many blocks, improving performance above caves (if you have your machines in caves, for some reason). This should ideally be set lower than the horizontal distance.").setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.get()).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxTileEntityDistance).add((Option)maxTileEntityDistanceVertical).build());
    }

    @Inject(method={"general"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true)
    private static void InjectGeneral(CallbackInfoReturnable<OptionPage> cir, List<OptionGroup> groups) {
        OptionImpl fullscreenMode = OptionImpl.createBuilder(MagnesiumExtrasConfig.FullscreenMode.class, (OptionStorage)vanillaOpts).setName("Fullscreen Mode").setTooltip("Windowed - the game will display in a small window.\nBorderless - the game will be fullscreened, and locked to your monitor's refresh rate, but allow you to tab out easily.\nFullscreen - the game will display in native fullscreen mode.").setControl(opt -> new CyclingControl((Option)opt, MagnesiumExtrasConfig.FullscreenMode.class, new String[]{"Windowed", "Borderless", "Fullscreen"})).setBinding((opts, value) -> {
            MagnesiumExtrasConfig.fullScreenMode.set((Object)value);
            opts.field_74353_u = value != MagnesiumExtrasConfig.FullscreenMode.WINDOWED;
            Minecraft client = Minecraft.func_71410_x();
            MainWindow window = client.func_228018_at_();
            if (window != null && window.func_198113_j() != opts.field_74353_u) {
                window.func_198077_g();
                opts.field_74353_u = window.func_198113_j();
            }
            if (window != null && opts.field_74353_u) {
                ((MainWindowAccessor)window).setDirty(true);
                window.func_198097_f();
            }
        }, opts -> (MagnesiumExtrasConfig.FullscreenMode)((Object)((Object)MagnesiumExtrasConfig.fullScreenMode.get()))).build();
        SodiumGameOptionsMixin.ReplaceOption(groups, "Fullscreen", fullscreenMode);
    }

    private static void ReplaceOption(List<OptionGroup> groups, String name, Option<?> replaceOption) {
        ArrayList<OptionGroup> newList = new ArrayList<OptionGroup>();
        for (OptionGroup optionGroup : groups) {
            OptionGroup.Builder builder = OptionGroup.createBuilder();
            for (Option option : optionGroup.getOptions()) {
                builder.add(Objects.equals(option.getName(), name) ? replaceOption : option);
            }
            newList.add(builder.build());
        }
        groups.clear();
        groups.addAll(newList);
    }

    @ModifyConstant(method={"experimental"}, remap=false, constant={@Constant(stringValue="Experimental")})
    private static String ChangeCategoryName(String old) {
        return "Extras";
    }
}

