/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.entity.ItemEntityManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.item.ItemEntity;

public class CommandItems
extends CustomCommand {
    private static final CommandItems command = new CommandItems();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"items").requires(cs -> cs.func_197034_c(2))).executes((Command)command)).then(Commands.func_197057_a((String)"optimize").executes(command::runOptimize));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Map<String, Set<ItemEntity>> itemTypeEntityMap = ItemEntityManager.getItemTypeEntityMap();
        if (itemTypeEntityMap.isEmpty()) {
            CommandItems.sendFeedback(context, "Unable to find any items entity. World is not loaded or nor items dropped?");
        } else {
            CommandItems.sendFeedback(context, String.format("Items Overview (%s types)\n===", itemTypeEntityMap.size()));
            for (Map.Entry<String, Set<ItemEntity>> itemEntities : itemTypeEntityMap.entrySet()) {
                int numOfItems = itemEntities.getValue().size();
                if (numOfItems <= 0) continue;
                CommandItems.sendFeedback(context, String.format("\u25cb %s %s", itemEntities.getKey(), numOfItems));
            }
        }
        return 0;
    }

    public int runOptimize(CommandContext<CommandSource> context) {
        CommandItems.sendFeedback(context, "Running manual Item Optimization ...");
        int numberOfRemovedItems = ItemEntityManager.optimizeItems();
        if (numberOfRemovedItems > 0) {
            CommandItems.sendFeedback(context, String.format("Removed items %s from all worlds!", numberOfRemovedItems));
        } else {
            CommandItems.sendFeedback(context, "Optimization was not needed!");
        }
        return 0;
    }
}

