/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.config.SpawnConfigManager;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CommandSpawnRules
extends CustomCommand {
    private static final CommandSpawnRules command = new CommandSpawnRules();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawnRules").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Set entitiesKeys = ForgeRegistries.ENTITIES.getKeys();
        if (entitiesKeys.isEmpty()) {
            CommandSpawnRules.sendFeedback(context, "Unable to find any entities. Server / World is not loaded?");
            return 0;
        }
        CommandSpawnRules.sendFeedback(context, "Spawn Rules, please check info.log for the full output.\n===");
        CommandSpawnRules.sendFeedback(context, "Entity Name|perPlayer|perWorld");
        for (ResourceLocation entityKey : entitiesKeys) {
            String entityName = entityKey.toString();
            if (entityName == null || !SpawnConfigManager.hasSpawnLimit(entityName)) continue;
            int spawnRatePerPlayer = SpawnConfigManager.getSpawnLimitPerPlayer(entityName);
            int spawnRatePerWorld = SpawnConfigManager.getSpawnLimitPerWorld(entityName);
            CommandSpawnRules.sendFeedback(context, String.format("%s|%s|%s", entityName, spawnRatePerPlayer, spawnRatePerWorld));
        }
        return 0;
    }
}

