/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.spawn.SpawnerManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;

public class CommandSpawner
extends CustomCommand {
    private static final CommandSpawner command = new CommandSpawner();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawner").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Set<MobSpawnerTileEntity> spawnerList = SpawnerManager.getSpawnerList();
        if (spawnerList.isEmpty()) {
            CommandSpawner.sendFeedback(context, "Unable to find any active mob spawner. World is not loaded or nor mob spawner loaded yet?");
        } else {
            CommandSpawner.sendFeedback(context, "Spawner Overview (please check latest.log for full output with positions)\n===");
            HashMap<String, Integer> spawnerCounter = new HashMap<String, Integer>();
            for (MobSpawnerTileEntity mobSpawnerTileEntity : spawnerList) {
                String worldName = mobSpawnerTileEntity.func_145831_w().func_234923_W_().func_240901_a_().toString();
                CompoundNBT spawnerData = mobSpawnerTileEntity.serializeNBT();
                String spawnEntityId = spawnerData.func_74775_l("SpawnData").func_74779_i("id");
                log.info("[Mob Spawner] {} at {} in {} with {}", (Object)spawnEntityId, (Object)mobSpawnerTileEntity.func_174877_v(), (Object)worldName, (Object)spawnerData);
                spawnerCounter.put(spawnEntityId, spawnerCounter.getOrDefault(spawnEntityId, 0) + 1);
            }
            for (Map.Entry entry : spawnerCounter.entrySet()) {
                CommandSpawner.sendFeedback(context, String.format("\u221f %s x %s", entry.getValue(), entry.getKey()));
            }
        }
        return 0;
    }
}

