/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoad;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.world.server.ServerWorld;

public class CommandWorlds
extends CustomCommand {
    private static final CommandWorlds command = new CommandWorlds();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"worlds").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Map<ServerWorld, Double> serverWorldLoad = ServerWorldLoad.getWorldLoad();
        if (serverWorldLoad.isEmpty()) {
            CommandWorlds.sendFeedback(context, "Unable to find any worlds. Server / World is not loaded?");
        } else {
            CommandWorlds.sendFeedback(context, "World Overview\n===");
            for (Map.Entry<ServerWorld, Double> worldEntry : serverWorldLoad.entrySet()) {
                ServerWorld serverWorld = worldEntry.getKey();
                String worldName = serverWorld.func_201672_e().func_234923_W_().func_240901_a_().toString();
                Double avgTickTime = worldEntry.getValue();
                CommandWorlds.sendFeedback(context, String.format("\u25cb %s %sms", worldName, avgTickTime));
            }
        }
        return 0;
    }
}

