/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final Logger log = LogManager.getLogger((String)"APTweaks");
    static final ForgeConfigSpec serverSpec;
    public static final Config SERVER;

    private ServerConfig() {
    }

    @SubscribeEvent
    public static void handleModConfigLoadEvent(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() != serverSpec) {
            return;
        }
        log.info("Loading server config file {} ...", (Object)config.getFileName());
    }

    @SubscribeEvent
    public static void handleModConfigReloadEvent(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() != serverSpec) {
            return;
        }
        log.info("Reloading server config file {} ...", (Object)config.getFileName());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Config)specPair.getLeft();
        log.info("Registering server config ...");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    public static class Config {
        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks (Server configuration)").push("server");
            builder.pop();
        }
    }
}

