/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.config.mods;

import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.SpawnConfigManager;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SpawnConfigModSupport {
    public static final Logger log = LogManager.getLogger((String)"APTweaks");
    public static final CommonConfig.Config COMMON = CommonConfig.COMMON;

    protected SpawnConfigModSupport() {
    }

    public static void addSpawnRatesForGeneralMobs(String name, Set<String> generalMobList, int maxGeneralMobsPerPlayer, int maxGeneralMobsPerWorld) {
        if (Boolean.FALSE.equals(SpawnConfigModSupport.COMMON.optimizeGeneralMobs.get()) || generalMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable general mobs spawn rate control for {} and {} mobs with maxPerPlayer:{} and maxPerWorld:{} ...", (Object)name, (Object)generalMobList.size(), (Object)maxGeneralMobsPerPlayer, (Object)maxGeneralMobsPerWorld);
        SpawnConfigModSupport.addSpawnRatesForGeneralMobs(generalMobList, maxGeneralMobsPerPlayer, maxGeneralMobsPerWorld);
    }

    public static void addSpawnRatesForPassiveMobs(String name, Set<String> passiveMobList, int maxPassiveMobsPerPlayer, int maxPassiveMobsPerWorld) {
        if (Boolean.FALSE.equals(SpawnConfigModSupport.COMMON.optimizePassiveMobs.get()) || passiveMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable passive mobs spawn rate control for {} and {} mobs with maxPerPlayer:{} and maxPerWorld:{} ...", (Object)name, (Object)passiveMobList.size(), (Object)maxPassiveMobsPerPlayer, (Object)maxPassiveMobsPerWorld);
        SpawnConfigModSupport.addSpawnRatesForPassiveMobs(passiveMobList, maxPassiveMobsPerPlayer, maxPassiveMobsPerWorld);
    }

    public static void addSpawnRatesForNeutralMobs(String name, Set<String> neutralMobList, int maxNeutralMobsPerPlayer, int maxNeutralMobsPerWorld) {
        if (Boolean.FALSE.equals(SpawnConfigModSupport.COMMON.optimizeNeutralMobs.get()) || neutralMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable neutral mobs spawn rate control for {} and {} mobs with maxPerPlayer:{} and maxPerWorld:{} ...", (Object)name, (Object)neutralMobList.size(), (Object)maxNeutralMobsPerPlayer, (Object)maxNeutralMobsPerWorld);
        SpawnConfigModSupport.addSpawnRatesForNeutralMobs(neutralMobList, maxNeutralMobsPerPlayer, maxNeutralMobsPerWorld);
    }

    public static void addSpawnRatesForHostileMobs(String name, Set<String> hostileMobList, int maxHostileMobsPerPlayer, int maxHostileMobsPerWorld) {
        if (Boolean.FALSE.equals(SpawnConfigModSupport.COMMON.optimizeHostileMobs.get()) || hostileMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable hostile mobs spawn rate control for {} and {} mobs with maxPerPlayer:{} and maxPerWorld:{} ...", (Object)name, (Object)hostileMobList.size(), (Object)maxHostileMobsPerPlayer, (Object)maxHostileMobsPerWorld);
        SpawnConfigModSupport.addSpawnRatesForHostileMobs(hostileMobList, maxHostileMobsPerPlayer, maxHostileMobsPerWorld);
    }

    public static void addSpawnRatesForBossMobs(String name, Set<String> bossMobList, int maxBossMobsPerPlayer, int maxBossMobsPerWorld) {
        if (Boolean.FALSE.equals(SpawnConfigModSupport.COMMON.optimizeBossMobs.get()) || bossMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable boss mobs spawn rate control for {} and {} mobs with maxPerPlayer:{} and maxPerWorld:{} ...", (Object)name, (Object)bossMobList.size(), (Object)maxBossMobsPerPlayer, (Object)maxBossMobsPerWorld);
        SpawnConfigModSupport.addSpawnRatesForBossMobs(bossMobList, maxBossMobsPerPlayer, maxBossMobsPerWorld);
    }

    public static void addSpecialSpawnRates(String name, Map<String, Integer> specialMobList) {
        if (specialMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable special mobs spawn rate control for {} and {} mobs with: {}", (Object)name, (Object)specialMobList.size(), specialMobList);
        SpawnConfigModSupport.addSpecialSpawnRates(specialMobList);
    }

    public static void addSpawnRatesForGeneralMobs(Set<String> generalMobList, int maxGeneralMobsPerPlayer, int maxGeneralMobsPerWorld) {
        for (String entity : generalMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxGeneralMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxGeneralMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpawnRatesForPassiveMobs(Set<String> passiveMobList, int maxPassiveMobsPerPlayer, int maxPassiveMobsPerWorld) {
        for (String entity : passiveMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxPassiveMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxPassiveMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpawnRatesForNeutralMobs(Set<String> neutralMobList, int maxNeutralMobsPerPlayer, int maxNeutralMobsPerWorld) {
        for (String entity : neutralMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxNeutralMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxNeutralMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpawnRatesForHostileMobs(Set<String> hostileMobList, int maxHostileMobsPerPlayer, int maxHostileMobsPerWorld) {
        for (String entity : hostileMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxHostileMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxHostileMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpawnRatesForBossMobs(Set<String> bossMobList, int maxBossMobsPerPlayer, int maxBossMobsPerWorld) {
        for (String entity : bossMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxBossMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxBossMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpecialSpawnRates(Map<String, Integer> specialMobList) {
        for (Map.Entry<String, Integer> entry : specialMobList.entrySet()) {
            String entity = entry.getKey();
            int maxSpecialMobsPerWorld = entry.getValue();
            SpawnConfigManager.addSpawnConfigSpecial(entity, maxSpecialMobsPerWorld);
            SpawnConfigManager.addSpawnConfigEntity(entity);
        }
    }

    public static void addSpawnRateForMob(String entity, int maxMobsPerPlayer, int maxMobsPerWorld) {
        SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxMobsPerPlayer);
        SpawnConfigManager.addSpawnConfigPerWorld(entity, maxMobsPerWorld);
        SpawnConfigManager.addSpawnConfigEntity(entity);
    }
}

