/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.player;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerPositionManager
extends Manager {
    private static Map<String, PlayerPosition> playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    private static int ticks = 0;
    public static final String LOG_NAME = PlayerPositionManager.class.getSimpleName();
    private static final Logger log = PlayerPositionManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(FMLServerStartingEvent event) {
        log.info("Player position will be expanded by factor x:{} y:{} z:{} and view area by factor {}.", CommonConfig.COMMON.viewAreaXFactor.get(), CommonConfig.COMMON.viewAreaYFactor.get(), CommonConfig.COMMON.viewAreaZFactor.get(), CommonConfig.COMMON.viewAreaDistanceFactor.get());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().func_200200_C_().getString();
        if (!username.isEmpty()) {
            log.debug("Removing player {} from tracking.", (Object)event.getEntity());
            playerPositionMap.remove(username);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ticks;
            return;
        }
        if (ticks == 50) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (!player.func_70089_S() || player.func_193105_t()) continue;
                PlayerPositionManager.updatePlayerPosition(player);
            }
            ticks = 0;
        }
    }

    public static List<PlayerPosition> getPlayerPositionsInsideViewArea(String world, int x, int y, int z) {
        ArrayList<PlayerPosition> playerPositions = new ArrayList<PlayerPosition>();
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            playerPositions.add(playerPosition);
        }
        return playerPositions;
    }

    public static boolean isInsidePlayersViewArea(String world, int x, int y, int z) {
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, PlayerPosition> getPlayerPositionMap() {
        return playerPositionMap;
    }

    private static void updatePlayerPosition(ServerPlayerEntity player) {
        String username = player.func_200200_C_().getString();
        playerPositionMap.computeIfAbsent(username, k -> new PlayerPosition(player));
        PlayerPosition playerPosition = playerPositionMap.get(username);
        if (playerPosition.update(player)) {
            log.debug("Update player position for {} with {}", (Object)username, (Object)playerPosition);
        }
    }
}

