/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.server;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoad;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoad;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerManager
extends Manager {
    private static short ticks = 0;
    private static final short SERVER_LOAD_TICK = 20;
    private static final short WORLD_LOAD_TICK = 40;
    private static final short OPTIMIZATION_TICK = 60;
    private static final short RESET_TICK = 120;
    private static final Logger log = ServerManager.getLogger(ServerManager.class.getSimpleName());

    @SubscribeEvent
    public static void handleServerStartingEvent(FMLServerStartingEvent event) {
        log.info("Game Difficulty is set to {}", (Object)ServerLifecycleHooks.getCurrentServer().func_240793_aU_().func_176130_y());
        log.info("Max number of players is set to {}", (Object)ServerLifecycleHooks.getCurrentServer().func_184103_al().func_72352_l());
        ServerLoad.measureLoadAndPost();
        ServerWorldLoad.measureLoadAndPost();
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ticks = (short)(ticks + 1);
            return;
        }
        if (ticks == 20) {
            ServerLoad.measureLoadAndPost();
        } else if (ticks == 40) {
            ServerWorldLoad.measureLoadAndPost();
        } else if (ticks == 60) {
            MinecraftForge.EVENT_BUS.post((Event)new OptimizationEvent());
        } else if (ticks >= 120) {
            ticks = 0;
        }
    }
}

