/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.spawn;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.config.SpawnConfigManager;
import de.markusbordihn.adaptiveperformancetweaks.entity.EntityManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPosition;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPositionManager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoadEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnManager
extends Manager {
    private static Boolean isUntamedWildModLoaded = ModList.get().isLoaded("untamedwilds");
    private static Map<String, Boolean> serverWorldLoadMap = new HashMap<String, Boolean>();
    private static Map<String, Double> serverWorldLoadFactorMap = new HashMap<String, Double>();
    private static Map<String, Integer> spawnConfigPerPlayer = SpawnConfigManager.getSpawnConfigPerPlayer();
    private static Map<String, Integer> spawnConfigPerWorld = SpawnConfigManager.getSpawnConfigPerWorld();
    private static Map<String, Integer> spawnConfigSpecial = SpawnConfigManager.getSpawnConfigSpecial();
    private static Set<String> spawnConfigEntity = SpawnConfigManager.getSpawnConfigEntity();
    private static String lastBlockedSpawnEntityByPlayerLimit = "";
    private static String lastBlockedSpawnEntityByViewArea = "";
    private static String lastBlockedSpawnEntityByWorldLimit = "";
    private static double difficultyFactor = 1.0;
    private static int spawnLimiter = 0;
    private static Set<String> allowList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnAllowList.get());
    private static Set<String> denyList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnDenyList.get());
    private static boolean spawnLimitationEnabled = (Boolean)SpawnManager.COMMON.spawnLimitationEnabled.get();
    private static int spawnLimitationLimiter = (Integer)SpawnManager.COMMON.spawnLimitationLimiter.get();
    private static int spawnLimitationMaxMobsPerPlayer = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerPlayer.get();
    private static int spawnLimitationMaxMobsPerWorld = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerWorld.get();
    public static final String LOG_NAME = SpawnManager.class.getSimpleName();
    private static final Logger log = SpawnManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        serverWorldLoadMap = new HashMap<String, Boolean>();
        serverWorldLoadFactorMap = new HashMap<String, Double>();
        allowList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnAllowList.get());
        denyList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnDenyList.get());
        spawnLimitationEnabled = (Boolean)SpawnManager.COMMON.spawnLimitationEnabled.get();
        spawnLimitationLimiter = (Integer)SpawnManager.COMMON.spawnLimitationLimiter.get();
        spawnLimitationMaxMobsPerPlayer = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerPlayer.get();
        spawnLimitationMaxMobsPerWorld = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerWorld.get();
    }

    @SubscribeEvent
    public static void handleServerStarting(FMLServerStartingEvent event) {
        SpawnManager.updateGameDifficulty(ServerLifecycleHooks.getCurrentServer().func_240793_aU_().func_176130_y());
        if (!allowList.isEmpty()) {
            log.info("Allow List: {}", allowList);
        }
        if (!denyList.isEmpty()) {
            log.info("Deny List: {}", denyList);
        }
        if (spawnLimitationEnabled) {
            if (spawnLimitationLimiter > 0) {
                log.info("\u2713 Enable limiter and block randomly every {} unknown mob from spawning ...", (Object)spawnLimitationLimiter);
            }
            if (spawnLimitationMaxMobsPerWorld > 0) {
                log.info("\u2713 Enable spawn rate control with max {} per world ...", (Object)spawnLimitationMaxMobsPerWorld);
            }
            if (spawnLimitationMaxMobsPerPlayer > 0) {
                log.info("\u2713 Enable spawn rate control with max {} per player ...", (Object)spawnLimitationMaxMobsPerPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void handleServerWorldLoadEvent(ServerWorldLoadEvent event) {
        if (event.hasChanged()) {
            String worldName = event.getServerWorldName();
            serverWorldLoadFactorMap.put(worldName, event.getServerWorldLoadLevelFactor());
            serverWorldLoadMap.put(worldName, event.hasLowServerWorldLoad());
        }
    }

    @SubscribeEvent
    public static void handleDifficultyChangeEvent(DifficultyChangeEvent event) {
        SpawnManager.updateGameDifficulty(event.getDifficulty());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLivingCheckSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        SpawnManager.handleSpawnEvent((LivingSpawnEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLivingSpecialSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
        SpawnManager.handleSpawnEvent((LivingSpawnEvent)event);
    }

    private static void handleSpawnEvent(LivingSpawnEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
            log.debug("[Canceled / denied Spawn Event] Ignore spawn event {}!", (Object)event);
            return;
        }
        Entity entity = event.getEntity();
        String entityName = entity.func_70022_Q();
        World world = entity.field_70170_p;
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        if (entityName == null) {
            if (entity.isMultipartEntity() || entity.func_200600_R().toString().contains("body_part")) {
                log.debug("[Multipart Entity] Allow spawn event for {} in {}", (Object)entity, (Object)worldName);
            } else {
                log.warn("Unknown entity name for spawn entity {} ({}) in {}. Please report this issue under {}]!", (Object)entity, (Object)entity.func_200600_R(), (Object)worldName, (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues/");
            }
            return;
        }
        if (allowList.contains(entityName)) {
            log.debug("[Allowed Entity] Allow spawn event for {} in {} ", (Object)entity, (Object)worldName);
            return;
        }
        if (denyList.contains(entityName)) {
            log.debug("[Denied Entity] Denied spawn event for {} in {} ", (Object)entity, (Object)worldName);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (entity.func_145818_k_()) {
            log.debug("[Custom Entity] Skip spawn event for {} in {} ", (Object)entity, (Object)worldName);
            return;
        }
        if (entity instanceof ProjectileEntity || entity instanceof DamagingProjectileEntity) {
            return;
        }
        List<PlayerPosition> playersPositionsInsideViewArea = PlayerPositionManager.getPlayerPositionsInsideViewArea(worldName, (int)event.getX(), (int)event.getY(), (int)event.getZ());
        Integer numOfPlayersInsideViewArea = playersPositionsInsideViewArea.size();
        if (numOfPlayersInsideViewArea == 0) {
            log.debug("[View Area Visibility] Blocked spawn event for {} in {}.", (Object)entity, (Object)worldName);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!spawnConfigEntity.contains(entityName) && !spawnConfigEntity.contains(worldName + ':' + entityName)) {
            if (spawnLimitationEnabled) {
                if (spawnLimitationLimiter > 0 && spawnLimiter++ >= spawnLimitationLimiter) {
                    log.debug("[Spawn Limiter {}] Blocked spawn event for unknown {} in {}.", (Object)spawnLimitationLimiter, (Object)entity, (Object)worldName);
                    event.setResult(Event.Result.DENY);
                    spawnLimiter = 0;
                    return;
                }
                int numberOfEntities = EntityManager.getNumberOfEntities(worldName, entityName);
                if (spawnLimitationMaxMobsPerWorld > 0 && numberOfEntities >= spawnLimitationMaxMobsPerWorld) {
                    log.debug("[World limit] Blocked spawn event for unknown {} ({} >= {}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)spawnLimitationMaxMobsPerWorld, (Object)worldName);
                    event.setResult(Event.Result.DENY);
                    return;
                }
                if (spawnLimitationMaxMobsPerPlayer > 0 && numberOfEntities >= spawnLimitationMaxMobsPerPlayer * numOfPlayersInsideViewArea) {
                    log.debug("[Player limit] Blocked spawn event for unknown {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)spawnLimitationMaxMobsPerPlayer, (Object)worldName);
                    event.setResult(Event.Result.DENY);
                    return;
                }
                int numberOfEntitiesInsideViewArea = EntityManager.getNumberOfEntitiesInPlayerPositions(worldName, entityName, playersPositionsInsideViewArea);
                if (spawnLimitationMaxMobsPerPlayer > 0 && numberOfEntitiesInsideViewArea >= spawnLimitationMaxMobsPerPlayer * numOfPlayersInsideViewArea) {
                    log.debug("[View Area Limit] Blocked spawn event for unknown {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntitiesInsideViewArea, (Object)spawnLimitationMaxMobsPerPlayer, (Object)worldName);
                    event.setResult(Event.Result.DENY);
                    return;
                }
            }
            log.debug("[Untracked Entity] Skip spawn event for {} in {}", (Object)entityName, (Object)worldName);
            return;
        }
        boolean hasLowWorldLoad = serverWorldLoadMap.getOrDefault(worldName, false);
        AbstractSpawner spawner = null;
        if (event instanceof LivingSpawnEvent.CheckSpawn && (spawner = ((LivingSpawnEvent.CheckSpawn)event).getSpawner()) != null && hasLowWorldLoad) {
            log.debug("[Spawner Entity] Ignore spawn event for {} in {}", (Object)entityName, (Object)worldName);
            return;
        }
        double serverWorldLoadFactor = serverWorldLoadFactorMap.getOrDefault(worldName, 1.0);
        double spawnFactor = entity instanceof MonsterEntity ? serverWorldLoadFactor * difficultyFactor : serverWorldLoadFactor;
        int numberOfEntities = EntityManager.getNumberOfEntities(worldName, entityName);
        int spawnLimitSpecial = spawnConfigSpecial.getOrDefault(worldName + ':' + entityName, -1);
        if (spawnLimitSpecial >= 0) {
            if ((double)numberOfEntities >= (double)spawnLimitSpecial * spawnFactor) {
                log.debug("[Special limit] Blocked spawn event for {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)spawnLimitSpecial, (Object)spawnFactor, (Object)worldName);
                event.setResult(Event.Result.DENY);
                return;
            }
            log.debug("[Allow Special Spawn] For {} ({}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)worldName);
            return;
        }
        int spawnLimitPerWorld = spawnConfigPerWorld.getOrDefault(entityName, -1);
        if (spawnLimitPerWorld >= 0 && (double)numberOfEntities >= (double)spawnLimitPerWorld * spawnFactor) {
            if (!lastBlockedSpawnEntityByWorldLimit.equals(entityName)) {
                lastBlockedSpawnEntityByWorldLimit = entityName;
                log.debug("[World limit] Blocked spawn event for {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)spawnLimitPerWorld, (Object)spawnFactor, (Object)worldName);
            }
            event.setResult(Event.Result.DENY);
            return;
        }
        int spawnLimitPerPlayer = spawnConfigPerPlayer.getOrDefault(entityName, -1);
        if (spawnLimitPerPlayer >= 0 && (double)numberOfEntities >= (double)(spawnLimitPerPlayer * numOfPlayersInsideViewArea) * spawnFactor) {
            if (!lastBlockedSpawnEntityByPlayerLimit.equals(entityName)) {
                lastBlockedSpawnEntityByPlayerLimit = entityName;
                log.debug("[Player limit] Blocked spawn event for {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntities, (Object)spawnLimitPerPlayer, (Object)spawnFactor, (Object)worldName);
            }
            event.setResult(Event.Result.DENY);
            return;
        }
        boolean runViewAreaCheck = true;
        if (Boolean.TRUE.equals(isUntamedWildModLoaded) && entityName.startsWith("untamedwilds:")) {
            runViewAreaCheck = false;
        }
        int numberOfEntitiesInsideViewArea = EntityManager.getNumberOfEntitiesInPlayerPositions(worldName, entityName, playersPositionsInsideViewArea);
        if (runViewAreaCheck && (double)numberOfEntitiesInsideViewArea >= (double)(spawnLimitPerPlayer * numOfPlayersInsideViewArea) * spawnFactor) {
            if (!lastBlockedSpawnEntityByViewArea.equals(entityName)) {
                lastBlockedSpawnEntityByViewArea = entityName;
                log.debug("[View Area Limit] Blocked spawn event for {} ({} >= {} * {}) in {}", (Object)entityName, (Object)numberOfEntitiesInsideViewArea, (Object)spawnLimitPerPlayer, (Object)spawnFactor, (Object)worldName);
            }
            event.setResult(Event.Result.DENY);
            return;
        }
        if (spawner == null) {
            if (event instanceof LivingSpawnEvent.SpecialSpawn) {
                log.debug("[Special Spawn Event] Allow special spawn Event {}", (Object)entity);
            } else {
                log.debug("[Allow Spawn] For {} in {} with {} in view and {} in world", (Object)entityName, (Object)worldName, (Object)numberOfEntitiesInsideViewArea, (Object)numberOfEntities);
            }
        }
    }

    public static void updateGameDifficulty(Difficulty difficulty) {
        log.debug("Changed game difficulty to {}", (Object)difficulty);
        switch (difficulty) {
            case EASY: {
                difficultyFactor = 0.75;
                break;
            }
            case NORMAL: 
            case PEACEFUL: {
                difficultyFactor = 1.0;
                break;
            }
            case HARD: {
                difficultyFactor = 1.5;
                break;
            }
            default: {
                difficultyFactor = 1.0;
            }
        }
    }
}

