/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.EmojifulConfig;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.util.EmojiUtil;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TextProcessing;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class EmojiFontRenderer
extends FontRenderer {
    private static String MY_NAME = "DevNotWorkingRn";
    public static LoadingCache<String, Pair<String, HashMap<Integer, Emoji>>> RECENT_STRINGS = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Pair<String, HashMap<Integer, Emoji>>>(){

        public Pair<String, HashMap<Integer, Emoji>> load(String key) throws Exception {
            return EmojiFontRenderer.getEmojiFormattedString(key);
        }
    });
    private TextureAtlasSprite sprite;

    public EmojiFontRenderer(FontRenderer fontRenderer) {
        super(fontRenderer.field_211127_e);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public int func_78256_a(String text) {
        if (text != null) {
            try {
                text = (String)((Pair)RECENT_STRINGS.get((Object)text.replaceAll(MY_NAME, MY_NAME + " :blobcatbolb: "))).getKey();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.func_78256_a(text);
    }

    public int func_238414_a_(ITextProperties textProperties) {
        if (textProperties instanceof StringTextComponent) {
            try {
                return super.func_238414_a_((ITextProperties)new StringTextComponent((String)((Pair)RECENT_STRINGS.get((Object)textProperties.getString().replaceAll(MY_NAME, MY_NAME + " :blobcatbolb: "))).getKey()).func_230530_a_(((StringTextComponent)textProperties).func_150256_b()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.func_78256_a(textProperties.getString());
    }

    public int func_243245_a(IReorderingProcessor processor) {
        StringBuilder builder = new StringBuilder();
        processor.accept((p_accept_1_, p_accept_2_, ch) -> {
            builder.append((char)ch);
            return true;
        });
        return this.func_78256_a(builder.toString());
    }

    public static Pair<String, HashMap<Integer, Emoji>> getEmojiFormattedString(String text) {
        LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap<Integer, Emoji>();
        if (((Boolean)EmojifulConfig.getInstance().renderEmoji.get()).booleanValue() && !StringUtil.isNullOrEmpty((String)text)) {
            String unformattedText = TextFormatting.func_110646_a((String)text);
            if (StringUtil.isNullOrEmpty((String)unformattedText)) {
                return Pair.of((Object)text, emojis);
            }
            for (Emoji emoji : Emojiful.EMOJI_LIST) {
                Pattern pattern = emoji.getRegex();
                Matcher matcher = pattern.matcher(unformattedText);
                while (matcher.find()) {
                    if (matcher.group().isEmpty()) continue;
                    String emojiText = matcher.group();
                    int index = text.indexOf(emojiText);
                    emojis.put(index, emoji);
                    LinkedHashMap<Integer, Emoji> clean = new LinkedHashMap<Integer, Emoji>();
                    for (Integer integer : new ArrayList(((HashMap)emojis).keySet())) {
                        if (integer <= index) continue;
                        Emoji e = (Emoji)((HashMap)emojis).get(integer);
                        emojis.remove(integer);
                        clean.put(integer - emojiText.length() + 1, e);
                    }
                    emojis.putAll(clean);
                    unformattedText = unformattedText.replaceFirst(Pattern.quote(emojiText), "\u2603");
                    text = text.replaceFirst("(?i)" + Pattern.quote(emojiText), "\u2603");
                }
            }
        }
        return Pair.of((Object)text, emojis);
    }

    public int func_228079_a_(String p_228079_1_, float p_228079_2_, float p_228079_3_, int p_228079_4_, boolean p_228079_5_, Matrix4f p_228079_6_, IRenderTypeBuffer p_228079_7_, boolean p_228079_8_, int p_228079_9_, int p_228079_10_) {
        return super.func_228079_a_(p_228079_1_, p_228079_2_, p_228079_3_, p_228079_4_, p_228079_5_, p_228079_6_, p_228079_7_, p_228079_8_, p_228079_9_, p_228079_10_);
    }

    protected float func_228081_c_(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        if (text.isEmpty()) {
            return 0.0f;
        }
        HashMap emojis = new LinkedHashMap<Integer, Emoji>();
        try {
            Pair cache = (Pair)RECENT_STRINGS.get((Object)text.replaceAll(MY_NAME, MY_NAME + " :blobcatbolb: "));
            text = (String)cache.getLeft();
            emojis = (HashMap)cache.getRight();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        EmojiCharacterRenderer fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, isShadow, matrix, isTransparent, packedLight);
        TextProcessing.func_238346_c_((String)text, (Style)Style.field_240709_b_, (ICharacterConsumer)fontrenderer$characterrenderer);
        return fontrenderer$characterrenderer.func_238441_a_(colorBackgroundIn, x);
    }

    public int func_238416_a_(IReorderingProcessor reorderingProcessor, float x, float y, int color, boolean isShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        if (reorderingProcessor != null) {
            String text;
            StringBuilder builder = new StringBuilder();
            if (reorderingProcessor != null) {
                reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                    builder.append((char)ch);
                    return true;
                });
            }
            if ((text = builder.toString().replaceAll(MY_NAME, MY_NAME + " :blobcatbolb:")).length() > 0) {
                EmojiCharacterRenderer fontrenderer$characterrenderer;
                color = (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
                LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap();
                try {
                    Pair cache = (Pair)RECENT_STRINGS.get((Object)text);
                    text = (String)cache.getLeft();
                    emojis = (HashMap)cache.getRight();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                ArrayList processors = new ArrayList();
                LinkedHashMap finalEmojis = emojis;
                AtomicInteger cleanPos = new AtomicInteger();
                AtomicBoolean ignore = new AtomicBoolean(false);
                reorderingProcessor.accept((pos, style, ch) -> {
                    if (!ignore.get()) {
                        if (finalEmojis.get(cleanPos.get()) == null) {
                            processors.add(new CharacterProcessor(cleanPos.getAndIncrement(), style, ch));
                        } else {
                            processors.add(new CharacterProcessor(cleanPos.get(), style, 32));
                            ignore.set(true);
                            return true;
                        }
                    }
                    if (ch == 58) {
                        ignore.set(false);
                        cleanPos.getAndIncrement();
                    }
                    return true;
                });
                StringBuilder builder2 = new StringBuilder();
                IReorderingProcessor.func_242247_b(processors).accept((p_accept_1_, p_accept_2_, ch) -> {
                    builder2.append((char)ch);
                    return true;
                });
                Matrix4f matrix4f = matrix.func_226601_d_();
                if (isShadow) {
                    fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, true, matrix, isTransparent, packedLight);
                    IReorderingProcessor.func_242247_b(processors).accept((ICharacterConsumer)fontrenderer$characterrenderer);
                    fontrenderer$characterrenderer.func_238441_a_(colorBackgroundIn, x);
                    matrix4f.func_226597_a_(field_238401_c_);
                }
                fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, false, matrix4f, isTransparent, packedLight);
                IReorderingProcessor.func_242247_b(processors).accept((ICharacterConsumer)fontrenderer$characterrenderer);
                return (int)fontrenderer$characterrenderer.func_238441_a_(colorBackgroundIn, x);
            }
        }
        return super.func_238416_a_(reorderingProcessor, x, y, color, isShadow, matrix, buffer, isTransparent, colorBackgroundIn, packedLight);
    }

    @OnlyIn(value=Dist.CLIENT)
    class EmojiCharacterRenderer
    implements ICharacterConsumer {
        final IRenderTypeBuffer buffer;
        private final boolean field_238429_c_;
        private final float field_238430_d_;
        private final float field_238431_e_;
        private final float field_238432_f_;
        private final float field_238433_g_;
        private final float field_238434_h_;
        private final Matrix4f matrix;
        private final boolean field_238436_j_;
        private final int packedLight;
        private float field_238438_l_;
        private float field_238439_m_;
        private HashMap<Integer, Emoji> emojis;
        @Nullable
        private List<TexturedGlyph.Effect> field_238440_n_;

        private void func_238442_a_(TexturedGlyph.Effect p_238442_1_) {
            if (this.field_238440_n_ == null) {
                this.field_238440_n_ = Lists.newArrayList();
            }
            this.field_238440_n_.add(p_238442_1_);
        }

        public EmojiCharacterRenderer(HashMap<Integer, Emoji> emojis, IRenderTypeBuffer p_i232250_2_, float p_i232250_3_, float p_i232250_4_, int p_i232250_5_, boolean p_i232250_6_, Matrix4f p_i232250_7_, boolean p_i232250_8_, int p_i232250_9_) {
            this.buffer = p_i232250_2_;
            this.emojis = emojis;
            this.field_238438_l_ = p_i232250_3_;
            this.field_238439_m_ = p_i232250_4_;
            this.field_238429_c_ = p_i232250_6_;
            this.field_238430_d_ = p_i232250_6_ ? 0.25f : 1.0f;
            this.field_238431_e_ = (float)(p_i232250_5_ >> 16 & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238432_f_ = (float)(p_i232250_5_ >> 8 & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238433_g_ = (float)(p_i232250_5_ & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238434_h_ = (float)(p_i232250_5_ >> 24 & 0xFF) / 255.0f;
            this.matrix = p_i232250_7_;
            this.field_238436_j_ = p_i232250_8_;
            this.packedLight = p_i232250_9_;
        }

        public boolean accept(int pos, Style style, int charInt) {
            Font font = EmojiFontRenderer.this.func_238419_a_(style.func_240729_k_());
            if (((Boolean)EmojifulConfig.getInstance().renderEmoji.get()).booleanValue() && this.emojis.get(pos) != null) {
                Emoji emoji = this.emojis.get(pos);
                if (emoji != null && !this.field_238429_c_) {
                    EmojiUtil.renderEmoji(emoji, this.field_238438_l_, this.field_238439_m_, this.matrix, this.buffer, this.packedLight);
                    this.field_238438_l_ += 10.0f;
                    return true;
                }
            } else {
                float f7;
                float f2;
                float f1;
                float f;
                IGlyph iglyph = font.func_238557_a_(charInt);
                TexturedGlyph texturedglyph = style.func_150233_f() && charInt != 32 ? font.func_211188_a(iglyph) : font.func_238559_b_(charInt);
                boolean flag = style.func_150223_b();
                float f3 = this.field_238434_h_;
                Color color = style.func_240711_a_();
                if (color != null) {
                    int i = color.func_240742_a_();
                    f = (float)(i >> 16 & 0xFF) / 255.0f * this.field_238430_d_;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.field_238430_d_;
                    f2 = (float)(i & 0xFF) / 255.0f * this.field_238430_d_;
                } else {
                    f = this.field_238431_e_;
                    f1 = this.field_238432_f_;
                    f2 = this.field_238433_g_;
                }
                if (!(texturedglyph instanceof EmptyGlyph)) {
                    float f5 = flag ? iglyph.func_223275_b_() : 0.0f;
                    float f4 = this.field_238429_c_ ? iglyph.func_223276_c_() : 0.0f;
                    IVertexBuilder ivertexbuilder = this.buffer.getBuffer(texturedglyph.func_228163_a_(this.field_238436_j_));
                    EmojiFontRenderer.this.func_228077_a_(texturedglyph, flag, style.func_150242_c(), f5, this.field_238438_l_ + f4, this.field_238439_m_ + f4, this.matrix, ivertexbuilder, f, f1, f2, f3, this.packedLight);
                }
                float f6 = iglyph.func_223274_a_(flag);
                float f4 = f7 = this.field_238429_c_ ? 1.0f : 0.0f;
                if (style.func_150236_d()) {
                    this.func_238442_a_(new TexturedGlyph.Effect(this.field_238438_l_ + f7 - 1.0f, this.field_238439_m_ + f7 + 4.5f, this.field_238438_l_ + f7 + f6, this.field_238439_m_ + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                if (style.func_150234_e()) {
                    this.func_238442_a_(new TexturedGlyph.Effect(this.field_238438_l_ + f7 - 1.0f, this.field_238439_m_ + f7 + 9.0f, this.field_238438_l_ + f7 + f6, this.field_238439_m_ + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                this.field_238438_l_ += f6;
                return true;
            }
            return false;
        }

        public float func_238441_a_(int p_238441_1_, float p_238441_2_) {
            if (p_238441_1_ != 0) {
                float f = (float)(p_238441_1_ >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(p_238441_1_ >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(p_238441_1_ >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(p_238441_1_ & 0xFF) / 255.0f;
                this.func_238442_a_(new TexturedGlyph.Effect(p_238441_2_ - 1.0f, this.field_238439_m_ + 9.0f, this.field_238438_l_ + 1.0f, this.field_238439_m_ - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.field_238440_n_ != null) {
                TexturedGlyph texturedglyph = EmojiFontRenderer.this.func_238419_a_(Style.field_240708_a_).func_228157_b_();
                IVertexBuilder ivertexbuilder = this.buffer.getBuffer(texturedglyph.func_228163_a_(this.field_238436_j_));
                for (TexturedGlyph.Effect texturedglyph$effect : this.field_238440_n_) {
                    texturedglyph.func_228162_a_(texturedglyph$effect, this.matrix, ivertexbuilder, this.packedLight);
                }
            }
            return this.field_238438_l_;
        }
    }

    class CharacterProcessor
    implements IReorderingProcessor {
        public final int pos;
        public final Style style;
        public final int character;

        CharacterProcessor(int pos, Style style, int character) {
            this.pos = pos;
            this.style = style;
            this.character = character;
        }

        public boolean accept(ICharacterConsumer iCharacterConsumer) {
            return iCharacterConsumer.accept(this.pos, this.style, this.character);
        }
    }
}

